/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.helpers;

import com.google.security.zynamics.binnavi.API.helpers.TreeNode;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public final class Tree<ObjectType> {
    private final TreeNode<ObjectType> m_rootNode;

    public Tree(com.google.security.zynamics.zylib.types.trees.Tree<ObjectType> tree) {
        this.m_rootNode = new TreeNode<ObjectType>(tree.getRootNode().getObject());
        Tree.generate(this.m_rootNode, tree.getRootNode());
    }

    private static <ObjectType> void generate(TreeNode<ObjectType> apiParent, ITreeNode<ObjectType> nativeNode) {
        for (ITreeNode<ObjectType> child : nativeNode.getChildren()) {
            TreeNode<ObjectType> newChild = new TreeNode<ObjectType>(child.getObject());
            TreeNode.link(apiParent, newChild);
            Tree.generate(newChild, child);
        }
    }

    public TreeNode<ObjectType> getRootNode() {
        return this.m_rootNode;
    }

    public List<TreeNode<ObjectType>> getTreeNodes() {
        TreeNode currentNode = this.m_rootNode;
        ArrayList<TreeNode<ObjectType>> nodeList = new ArrayList<TreeNode<ObjectType>>();
        nodeList.add(this.m_rootNode);
        Stack<TreeNode<ObjectType>> nodesToVisit = new Stack<TreeNode<ObjectType>>();
        for (TreeNode<ObjectType> treeNode : this.m_rootNode.getChildren()) {
            nodesToVisit.push(treeNode);
        }
        while (!nodesToVisit.isEmpty()) {
            currentNode = (TreeNode)nodesToVisit.pop();
            nodeList.add(currentNode);
            for (TreeNode<ObjectType> treeNode : currentNode.getChildren()) {
                nodesToVisit.push(treeNode);
            }
        }
        return nodeList;
    }

    public String toString() {
        String string2 = String.valueOf(this.m_rootNode.toString());
        return string2.length() != 0 ? "Tree with root node ".concat(string2) : new String("Tree with root node ");
    }
}

