/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.gui;

import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.gui.GraphWindow;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import java.util.ArrayList;
import java.util.List;

public final class GraphFrame {
    private final GraphWindow m_window;
    private final View2D m_view2d;
    private final BackEndDebuggerProvider m_debuggerProvider;
    private final List<Debugger> m_debuggers = new ArrayList<Debugger>();

    public GraphFrame(GraphWindow window, View2D view2d, BackEndDebuggerProvider debuggerProvider) {
        this.m_window = window;
        this.m_view2d = view2d;
        this.m_debuggerProvider = debuggerProvider;
    }

    public List<Debugger> getDebuggers() {
        if (this.m_debuggers.isEmpty()) {
            for (IDebugger debugger : this.m_debuggerProvider.getDebuggers()) {
                this.m_debuggers.add(new Debugger(debugger));
            }
        }
        return new ArrayList<Debugger>(this.m_debuggers);
    }

    public View2D getView2D() {
        return this.m_view2d;
    }

    public GraphWindow getWindow() {
        return this.m_window;
    }

    public String toString() {
        return String.format("Graph frame of view '%s'", this.m_view2d.toString());
    }
}

