/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CodeNode;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionNode;
import com.google.security.zynamics.binnavi.API.disassembly.InliningResult;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewGraph;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.disassembly.CInliningHelper;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CInliningResult;
import java.util.ArrayList;
import java.util.List;

public final class ViewGraphHelpers {
    private ViewGraphHelpers() {
    }

    public static CodeNode getCodeNode(ViewGraph graph, Address address) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        for (ViewNode node : graph) {
            CodeNode cnode;
            if (!(node instanceof CodeNode) || !(cnode = (CodeNode)node).getAddress().equals(address)) continue;
            return cnode;
        }
        return null;
    }

    public static CodeNode getCodeNode(ViewGraph graph, long address) {
        return ViewGraphHelpers.getCodeNode(graph, new Address(address));
    }

    public static List<CodeNode> getCodeNodes(ViewGraph graph) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        ArrayList<CodeNode> codeNodes = new ArrayList<CodeNode>();
        for (ViewNode node : graph) {
            if (!(node instanceof CodeNode)) continue;
            codeNodes.add((CodeNode)node);
        }
        return codeNodes;
    }

    public static FunctionNode getFunctionNode(ViewGraph graph, String functionName) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(functionName, "Error: Function name argument can not be null");
        for (ViewNode viewNode : graph) {
            FunctionNode fnode;
            if (!(viewNode instanceof FunctionNode) || !(fnode = (FunctionNode)viewNode).getFunction().getName().equals(functionName)) continue;
            return fnode;
        }
        return null;
    }

    public static List<FunctionNode> getFunctionNodes(ViewGraph graph) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        ArrayList<FunctionNode> functionNodes = new ArrayList<FunctionNode>();
        for (ViewNode node : graph) {
            if (!(node instanceof FunctionNode)) continue;
            functionNodes.add((FunctionNode)node);
        }
        return functionNodes;
    }

    public static Instruction getInstruction(ViewGraph graph, Address address) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        for (ViewNode node : graph) {
            if (!(node instanceof CodeNode)) continue;
            CodeNode cnode = (CodeNode)node;
            for (Instruction instruction : cnode.getInstructions()) {
                if (!instruction.getAddress().equals(address)) continue;
                return instruction;
            }
        }
        return null;
    }

    public static Instruction getInstruction(ViewGraph graph, long address) {
        return ViewGraphHelpers.getInstruction(graph, new Address(address));
    }

    public static InliningResult inlineFunctionCall(View view, CodeNode codeNode, Instruction instruction, Function function) {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        Preconditions.checkNotNull(codeNode, "Error: Code node argument can not be null");
        Preconditions.checkNotNull(instruction, "Error: Instruction argument can not be null");
        Preconditions.checkNotNull(function, "Error: Function argument can not be null");
        CInliningResult result = CInliningHelper.inlineCodeNode(view.getNative(), codeNode.getNative(), instruction.getNative(), function.getNative());
        CodeNode firstNode = (CodeNode)ObjectFinders.getObject(result.getFirstNode(), view.getGraph().getNodes());
        CodeNode secondNode = (CodeNode)(result.getSecondNode() == null ? null : ObjectFinders.getObject(result.getSecondNode(), view.getGraph().getNodes()));
        return new InliningResult(firstNode, secondNode);
    }
}

