/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.EdgeType;
import com.google.security.zynamics.binnavi.API.disassembly.IViewEdgeListener;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.graphs.DefaultEdge;
import java.awt.Color;
import java.util.List;

public final class ViewEdge
extends DefaultEdge<ViewNode>
implements ApiObject<INaviEdge> {
    private final INaviEdge m_edge;
    private final ListenerProvider<IViewEdgeListener> m_listeners = new ListenerProvider();

    public ViewEdge(INaviEdge edge, ViewNode source, ViewNode target) {
        super(source, target);
        this.m_edge = Preconditions.checkNotNull(edge, "Error: edge argument can not be null");
    }

    protected ListenerProvider<IViewEdgeListener> getListeners() {
        return this.m_listeners;
    }

    @Override
    public INaviEdge getNative() {
        return this.m_edge;
    }

    public void addListener(IViewEdgeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Color getColor() {
        return this.m_edge.getColor();
    }

    @Override
    public ViewNode getSource() {
        return (ViewNode)super.getSource();
    }

    @Override
    public ViewNode getTarget() {
        return (ViewNode)super.getTarget();
    }

    public EdgeType getType() {
        return EdgeType.convert(this.m_edge.getType());
    }

    public boolean isVisible() {
        return this.m_edge.isVisible();
    }

    public void removeListener(IViewEdgeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setColor(Color color) {
        this.m_edge.setColor(color);
    }

    public void setVisible(boolean value) {
        this.m_edge.setVisible(value);
    }

    public String toString() {
        return String.format("View Edge [%s -> %s]", ((ViewNode)super.getSource()).getName(), ((ViewNode)super.getTarget()).getName());
    }

    public void deleteLocalComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_edge.deleteLocalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public List<IComment> appendLocalComment(String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        try {
            return this.m_edge.appendLocalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public void initializeLocalComment(List<IComment> comments) {
        this.m_edge.initializeLocalComment(comments);
    }

    public IComment editLocalComment(IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_edge.editLocalComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void deleteGlobalComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_edge.deleteGlobalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public List<IComment> appendGlobalComment(String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        try {
            return this.m_edge.appendGlobalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public void initializeGlobalComment(List<IComment> comments) {
        this.m_edge.initializeGlobalComment(comments);
    }

    public IComment editGlobalComment(IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_edge.editGlobalComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }
}

