/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CodeNode;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.EdgeType;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionNode;
import com.google.security.zynamics.binnavi.API.disassembly.GraphType;
import com.google.security.zynamics.binnavi.API.disassembly.GroupNode;
import com.google.security.zynamics.binnavi.API.disassembly.IFunctionNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.IViewEdgeListener;
import com.google.security.zynamics.binnavi.API.disassembly.IViewListener;
import com.google.security.zynamics.binnavi.API.disassembly.IViewNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.PartialLoadException;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.disassembly.Tag;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.TextNode;
import com.google.security.zynamics.binnavi.API.disassembly.ViewContainer;
import com.google.security.zynamics.binnavi.API.disassembly.ViewEdge;
import com.google.security.zynamics.binnavi.API.disassembly.ViewGraph;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.API.disassembly.ViewType;
import com.google.security.zynamics.binnavi.API.reil.InternalTranslationException;
import com.google.security.zynamics.binnavi.API.reil.ReilFunction;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.REIL.InstructionFinders;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewEdge;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.binnavi.disassembly.views.ViewLoadEvents;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class View
implements ApiObject<INaviView> {
    private final ViewContainer viewContainer;
    private final INaviView naviView;
    private ViewGraph viewGraph;
    private final TagManager nodeTagManager;
    private final TagManager viewTagManager;
    private final List<Tag> viewTags = new ArrayList<Tag>();
    private final ListenerProvider<IViewListener> viewListeners = new ListenerProvider();
    private final InternalViewListener viewListener = new InternalViewListener();
    private final Map<INaviViewNode, ViewNode> cachedNodes = new HashMap<INaviViewNode, ViewNode>();
    private final Map<INaviEdge, ViewEdge> cachedEdges = new HashMap<INaviEdge, ViewEdge>();

    public View(ViewContainer container, INaviView view, TagManager nodeTagManager, TagManager viewTagManager) {
        this.viewContainer = Preconditions.checkNotNull(container, "Error: Container argument can not be null");
        this.naviView = Preconditions.checkNotNull(view, "Error: View argument can't be null");
        this.nodeTagManager = Preconditions.checkNotNull(nodeTagManager, "Error: Node tag manager argument can't be null");
        this.viewTagManager = Preconditions.checkNotNull(viewTagManager, "Error: View tag manager argument can't be null");
        for (CTag tag : view.getConfiguration().getViewTags()) {
            this.viewTags.add(viewTagManager.getTag(tag));
        }
        if (view.isLoaded()) {
            this.convertData();
        }
        view.addListener(this.viewListener);
    }

    private void adjustAttributes(ViewNode node, CNaviViewNode newNode) {
        newNode.setBorderColor(node.getBorderColor());
        newNode.setColor(node.getColor());
    }

    private ViewNode convert(INaviViewNode node) {
        if (node instanceof INaviCodeNode) {
            return new CodeNode(this, (INaviCodeNode)node, this.nodeTagManager);
        }
        if (node instanceof INaviFunctionNode) {
            Function function = this.getFunction(((INaviFunctionNode)node).getFunction());
            return new FunctionNode(this, (INaviFunctionNode)node, function, this.nodeTagManager);
        }
        if (node instanceof INaviTextNode) {
            return new TextNode(this, (INaviTextNode)node, this.nodeTagManager);
        }
        if (node instanceof INaviGroupNode) {
            return new GroupNode(this, (INaviGroupNode)node, this.nodeTagManager);
        }
        throw new IllegalStateException("Error: Unknown node type");
    }

    private void convertData() {
        IDirectedGraph<INaviViewNode, INaviEdge> graph = this.naviView.getGraph();
        ArrayList<ViewNode> blocks = new ArrayList<ViewNode>();
        ArrayList<ViewEdge> edges = new ArrayList<ViewEdge>();
        for (INaviViewNode block : graph.getNodes()) {
            ViewNode newBlock = this.convert(block);
            this.cachedNodes.put(block, newBlock);
            blocks.add(newBlock);
        }
        for (INaviViewNode block : graph.getNodes()) {
            if (block.getParentGroup() == null) continue;
            ((GroupNode)this.cachedNodes.get(block.getParentGroup())).addNode(this.cachedNodes.get(block));
        }
        for (INaviEdge edge : graph.getEdges()) {
            ViewNode source = this.cachedNodes.get(edge.getSource());
            ViewNode target = this.cachedNodes.get(edge.getTarget());
            ViewEdge viewEdge = new ViewEdge(edge, source, target);
            edges.add(viewEdge);
            this.cachedEdges.put(edge, viewEdge);
        }
        this.viewGraph = new ViewGraph((List<ViewNode>)blocks, (List<ViewEdge>)edges);
    }

    private boolean isConverted() {
        return this.viewGraph != null;
    }

    private Function getFunction(INaviFunction function) {
        Function apiFunction = this.viewContainer.getFunction(function);
        if (apiFunction != null) {
            return apiFunction;
        }
        for (Project project : this.viewContainer.getDatabase().getProjects()) {
            if (!project.isLoaded() || (apiFunction = project.getFunction(function)) == null) continue;
            return apiFunction;
        }
        throw new IllegalStateException(String.format("Error: Could not determine API function object for native function object '%s'", function.getName()));
    }

    @Override
    public INaviView getNative() {
        return this.naviView;
    }

    public void addListener(IViewListener listener) {
        this.viewListeners.addListener(listener);
    }

    public void addTag(Tag tag) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tag, "Error: Tag argument can't be null");
        try {
            this.naviView.getConfiguration().tagView((CTag)tag.getNative().getObject());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public boolean close() {
        return this.naviView.close();
    }

    public CodeNode createCodeNode(Function function, List<Instruction> instructions) {
        Preconditions.checkNotNull(instructions, "Error: Instructions argument can't be null");
        ArrayList<INaviInstruction> instructionsList = new ArrayList<INaviInstruction>();
        for (Instruction instruction : instructions) {
            Preconditions.checkNotNull(instruction, "Error: Instruction list contains a null-element");
            instructionsList.add(instruction.getNative());
        }
        assert (!instructions.isEmpty());
        CCodeNode newCodenode = this.naviView.getContent().createCodeNode(function == null ? null : function.getNative(), instructionsList);
        newCodenode.setColor(ConfigManager.instance().getColorSettings().getBasicBlocksColor());
        return (CodeNode)this.cachedNodes.get(newCodenode);
    }

    public ViewEdge createEdge(ViewNode source, ViewNode target, EdgeType edgeType) {
        Preconditions.checkNotNull(source, "Error: Source argument can not be null");
        Preconditions.checkNotNull(target, "Error: Target argument can not be null");
        Preconditions.checkNotNull(edgeType, "Error: Edge type argument can not be null");
        CNaviViewEdge newEdge = this.naviView.getContent().createEdge(source.getNative(), target.getNative(), edgeType.getNative());
        return this.cachedEdges.get(newEdge);
    }

    public FunctionNode createFunctionNode(Function function) {
        Preconditions.checkNotNull(function, "Error: Function argument can't be null");
        Preconditions.checkNotNull(this.getFunction(function.getNative()), "Error: Function does not belong to this container");
        CFunctionNode functionNode = this.naviView.getContent().createFunctionNode(function.getNative());
        return (FunctionNode)this.cachedNodes.get(functionNode);
    }

    public GroupNode createGroupNode(String text2, List<ViewNode> elements) {
        Preconditions.checkNotNull(text2, "Error: Text argument can not be null");
        Preconditions.checkNotNull(elements, "Error: Elements argument can not be null");
        ArrayList<INaviViewNode> nodes = new ArrayList<INaviViewNode>();
        for (ViewNode element : elements) {
            Preconditions.checkNotNull(element, "Error: Elements list contains a null-element");
            nodes.add(element.getNative());
        }
        CGroupNode newGroupNode = this.naviView.getContent().createGroupNode(nodes);
        return (GroupNode)this.cachedNodes.get(newGroupNode);
    }

    public ViewNode createNode(ViewNode node) {
        Preconditions.checkNotNull(node, "Error: Node argument can not be null");
        if (node instanceof CodeNode) {
            CCodeNode newNode;
            ArrayList<INaviInstruction> instructionsList = new ArrayList<INaviInstruction>();
            for (Instruction instruction : ((CodeNode)node).getInstructions()) {
                Preconditions.checkNotNull(instruction, "Error: Instruction list contains a null-element");
                instructionsList.add(instruction.getNative());
            }
            try {
                newNode = this.naviView.getContent().createCodeNode(((INaviCodeNode)node.getNative()).getParentFunction(), instructionsList);
            }
            catch (MaybeNullException e2) {
                newNode = this.naviView.getContent().createCodeNode(null, instructionsList);
            }
            this.adjustAttributes(node, newNode);
            return this.cachedNodes.get(newNode);
        }
        if (node instanceof FunctionNode) {
            CFunctionNode newNode = this.naviView.getContent().createFunctionNode(((INaviFunctionNode)node.getNative()).getFunction());
            this.adjustAttributes(node, newNode);
            return this.cachedNodes.get(newNode);
        }
        if (node instanceof TextNode) {
            CTextNode newNode = this.naviView.getContent().createTextNode(((TextNode)node).getComments());
            this.adjustAttributes(node, newNode);
            return this.cachedNodes.get(newNode);
        }
        if (node instanceof GroupNode) {
            throw new IllegalStateException("Group nodes can not be cloned");
        }
        throw new IllegalStateException("Error: Unknown node type");
    }

    public TextNode createTextNode(ArrayList<IComment> comments) {
        Preconditions.checkNotNull(comments, "Error: Text argument can not be null");
        CTextNode newTextNode = this.naviView.getContent().createTextNode(comments);
        return (TextNode)this.cachedNodes.get(newTextNode);
    }

    public void deleteEdge(ViewEdge edge) {
        Preconditions.checkNotNull(edge, "Error: Edge argument can't be null");
        this.naviView.getContent().deleteEdge(edge.getNative());
    }

    public void deleteNode(ViewNode node) {
        Preconditions.checkNotNull(node, "Error: Node argument can't be null");
        this.naviView.getContent().deleteNode(node.getNative());
    }

    public ViewContainer getContainer() {
        return this.viewContainer;
    }

    public String getDescription() {
        return this.naviView.getConfiguration().getDescription();
    }

    public int getEdgeCount() {
        return this.naviView.getEdgeCount();
    }

    public ViewGraph getGraph() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: View is not loaded");
        }
        return this.viewGraph;
    }

    public GraphType getGraphType() {
        return GraphType.convert(this.naviView.getGraphType());
    }

    public String getName() {
        return this.naviView.getName();
    }

    public int getNodeCount() {
        return this.naviView.getNodeCount();
    }

    public ReilFunction getReilCode() throws InternalTranslationException {
        try {
            return new ReilFunction(this.naviView.getContent().getReilCode());
        }
        catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
            throw new InternalTranslationException(e2, InstructionFinders.findInstruction(this, e2.getInstruction()));
        }
    }

    public List<Tag> getTags() {
        return new ArrayList<Tag>(this.viewTags);
    }

    public ViewType getType() {
        return ViewType.convert(this.naviView.getType());
    }

    public boolean isLoaded() {
        return this.naviView.isLoaded();
    }

    public void load() throws CouldntLoadDataException, PartialLoadException {
        if (this.isLoaded()) {
            return;
        }
        try {
            this.naviView.load();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException | LoadCancelledException e2) {
            throw new CouldntLoadDataException(e2);
        }
        catch (CPartialLoadException e3) {
            throw new PartialLoadException(e3);
        }
    }

    public void removeListener(IViewListener listener) {
        this.viewListeners.removeListener(listener);
    }

    public void removeTag(Tag tag) throws CouldntSaveDataException {
        try {
            this.naviView.getConfiguration().untagView((CTag)tag.getNative().getObject());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void save() throws CouldntSaveDataException {
        try {
            this.naviView.save();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        try {
            this.naviView.getConfiguration().setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.naviView.getConfiguration().setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        return String.format("View '%s'", this.getName());
    }

    private class InternalViewListener
    implements INaviViewListener {
        private InternalViewListener() {
        }

        @Override
        public void addedEdge(INaviView view, INaviEdge edge) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode source = (ViewNode)View.this.cachedNodes.get(edge.getSource());
            ViewNode target = (ViewNode)View.this.cachedNodes.get(edge.getTarget());
            ViewEdge newEdge = new ViewEdge(edge, source, target);
            View.this.viewGraph.addEdge(newEdge);
            View.this.cachedEdges.put(edge, newEdge);
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.addedEdge(View.this, newEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedNode(INaviView view, INaviViewNode node) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode newNode = View.this.convert(node);
            if (node instanceof INaviGroupNode) {
                INaviGroupNode gnode = (INaviGroupNode)node;
                for (INaviViewNode element : gnode.getElements()) {
                    ((GroupNode)newNode).addNode((ViewNode)View.this.cachedNodes.get(element));
                }
            }
            View.this.cachedNodes.put(node, newNode);
            View.this.viewGraph.addNode(newNode);
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.addedNode(View.this, newNode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedNodes(INaviView view, Collection<INaviViewNode> nodes) {
        }

        @Override
        public void appendedGlobalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void appendedLocalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void appendedLocalFunctionNodeComment(INaviView view, INaviFunctionNode node, IComment comment) {
            if (!View.this.isConverted()) {
                return;
            }
            FunctionNode viewNode = (FunctionNode)View.this.cachedNodes.get(node);
            for (IFunctionNodeListener listener : viewNode.getFunctionListeners()) {
                try {
                    listener.appendedComment(viewNode, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedBorderColor(INaviView view, IViewNode<?> node, Color color) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.changedBorderColor(viewNode, color);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedColor(INaviView view, CNaviViewEdge edge, Color color) {
            ViewEdge viewEdge = (ViewEdge)View.this.cachedEdges.get(edge);
            if (!View.this.isConverted()) {
                return;
            }
            for (IViewEdgeListener listener : viewEdge.getListeners()) {
                try {
                    listener.changedColor(viewEdge, color);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedColor(INaviView view, IViewNode<?> node, Color color) {
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            if (!View.this.isConverted()) {
                return;
            }
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.changedColor(viewNode, color);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDescription(INaviView view, String description) {
            if (!View.this.isConverted()) {
                return;
            }
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.changedDescription(View.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedGraphType(INaviView view, com.google.security.zynamics.zylib.disassembly.GraphType type, com.google.security.zynamics.zylib.disassembly.GraphType oldType) {
            if (!View.this.isConverted()) {
                return;
            }
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.changedGraphType(View.this, GraphType.convert(type));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedModificationDate(INaviView view, Date modificationDate) {
            for (IViewListener listener : View.this.viewListeners) {
                if (!View.this.isConverted()) {
                    return;
                }
                try {
                    listener.changedModificationDate(View.this, modificationDate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedModificationState(INaviView view, boolean value) {
        }

        @Override
        public void changedName(INaviView view, String name) {
            for (IViewListener listener : View.this.viewListeners) {
                if (!View.this.isConverted()) {
                    return;
                }
                try {
                    listener.changedName(View.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedParentGroup(INaviView view, INaviViewNode node, INaviGroupNode groupNode) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    if (groupNode == null) {
                        listener.changedParentGroup(viewNode, null);
                        continue;
                    }
                    listener.changedParentGroup(viewNode, (GroupNode)ObjectFinders.getObject(groupNode, View.this.viewGraph.getNodes()));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedSelection(INaviView view, IViewNode<?> node, boolean selected) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.changedSelection(viewNode, selected);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedStarState(INaviView view, boolean isStared) {
        }

        @Override
        public void changedVisibility(INaviView view, IViewEdge<?> edge) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewEdge viewEdge = (ViewEdge)View.this.cachedEdges.get(edge);
            for (IViewEdgeListener listener : viewEdge.getListeners()) {
                try {
                    listener.changedVisibility(viewEdge, viewEdge.isVisible());
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedVisibility(INaviView view, IViewNode<?> node, boolean visible) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.changedVisibility(viewNode, visible);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void closedView(INaviView view, IDirectedGraph<INaviViewNode, INaviEdge> oldGraph) {
            if (!View.this.isConverted()) {
                return;
            }
            View.this.viewGraph = null;
            View.this.cachedEdges.clear();
            View.this.cachedNodes.clear();
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.closedView(View.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean closingView(INaviView view) {
            if (!View.this.isConverted()) {
                return false;
            }
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    if (listener.closingView(View.this)) continue;
                    return false;
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            return true;
        }

        @Override
        public void deletedEdge(INaviView view, INaviEdge edge) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewEdge oldEdge = (ViewEdge)View.this.cachedEdges.get(edge);
            View.this.viewGraph.removeEdge(oldEdge);
            View.this.cachedEdges.remove(oldEdge);
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.deletedEdge(View.this, oldEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedGlobalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void deletedLocalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void deletedLocalFunctionNodeComment(INaviView view, INaviFunctionNode node, IComment comment) {
        }

        @Override
        public void deletedNode(INaviView view, INaviViewNode node) {
            if (node instanceof INaviGroupNode || !View.this.isConverted()) {
                return;
            }
            ViewNode oldNode = (ViewNode)View.this.cachedNodes.get(node);
            View.this.viewGraph.removeNode(oldNode);
            View.this.cachedNodes.remove(node);
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.deletedNode(View.this, oldNode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            for (INaviViewNode node : nodes) {
                if (!View.this.isConverted()) {
                    return;
                }
                ViewNode oldNode = (ViewNode)View.this.cachedNodes.get(node);
                View.this.viewGraph.removeNode(oldNode);
                View.this.cachedNodes.remove(node);
                for (IViewListener listener : View.this.viewListeners) {
                    try {
                        listener.deletedNode(View.this, oldNode);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedGlobalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void editedLocalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void editedLocalFunctionNodeComment(INaviView view, INaviFunctionNode node, IComment comment) {
        }

        @Override
        public void heightChanged(INaviView view, IViewNode<?> node, double height) {
        }

        @Override
        public void initializedGlobalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void initializedLoalFunctionNodeComment(INaviView view, INaviFunctionNode node, ArrayList<IComment> comments) {
        }

        @Override
        public void initializedLocalEdgeComment(INaviView view, INaviEdge edge) {
        }

        @Override
        public void loadedView(INaviView view) {
            View.this.convertData();
        }

        @Override
        public boolean loading(ViewLoadEvents event, int counter) {
            return true;
        }

        @Override
        public void savedView(INaviView view) {
        }

        @Override
        public void taggedNode(INaviView view, INaviViewNode node, CTag tag) {
            if (!View.this.isConverted()) {
                return;
            }
            Tag newTag = View.this.nodeTagManager.getTag(tag);
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.addedTag(viewNode, newTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void taggedView(INaviView view, CTag tag) {
            if (!View.this.isConverted()) {
                return;
            }
            Tag newTag = View.this.viewTagManager.getTag(tag);
            View.this.viewTags.add(newTag);
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.taggedView(View.this, newTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void untaggedNodes(INaviView view, INaviViewNode node, List<CTag> tags) {
            if (!View.this.isConverted()) {
                return;
            }
            for (CTag tag : tags) {
                Tag removedTag = View.this.nodeTagManager.getTag(tag);
                ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
                for (IViewNodeListener listener : viewNode.getListeners()) {
                    try {
                        listener.removedTag(viewNode, removedTag);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void untaggedView(INaviView view, CTag tag) {
            if (!View.this.isConverted()) {
                return;
            }
            Tag removedTag = View.this.viewTagManager.getTag(tag);
            View.this.viewTags.remove(removedTag);
            for (IViewListener listener : View.this.viewListeners) {
                try {
                    listener.untaggedView(View.this, removedTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void widthChanged(INaviView view, IViewNode<?> node, double height) {
        }

        @Override
        public void xposChanged(INaviView view, IViewNode<?> node, double xpos) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.changedX(viewNode, xpos);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void yposChanged(INaviView view, IViewNode<?> node, double ypos) {
            if (!View.this.isConverted()) {
                return;
            }
            ViewNode viewNode = (ViewNode)View.this.cachedNodes.get(node);
            for (IViewNodeListener listener : viewNode.getListeners()) {
                try {
                    listener.changedY(viewNode, ypos);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

