/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.ITextNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CNaviTextNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.List;

public final class TextNode
extends ViewNode {
    private final INaviTextNode m_node;
    private final ListenerProvider<ITextNodeListener> m_listeners = new ListenerProvider();
    private final InternalListener m_internalListener = new InternalListener();

    public TextNode(View view, INaviTextNode node, TagManager tagManager) {
        super(view, node, tagManager);
        this.m_node = node;
        node.addListener(this.m_internalListener);
    }

    @Override
    protected String getName() {
        return String.format("Text Node with: '%d' comments.", this.m_node.getComments().size());
    }

    public void addListener(ITextNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public List<IComment> appendComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        try {
            return this.m_node.appendComment(commentText);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public void initializeComment(List<IComment> comments) {
        this.m_node.initializeComment(comments);
    }

    public IComment editComment(IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_node.editComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void deleteComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_node.deleteComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public List<IComment> getComments() {
        return this.m_node.getComments();
    }

    public void removeListener(ITextNodeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalListener
    extends CNaviTextNodeListenerAdapter {
        private InternalListener() {
        }

        @Override
        public void changedText(CTextNode node, String text2) {
            for (ITextNodeListener listener : TextNode.this.m_listeners) {
                try {
                    listener.changedText(TextNode.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

