/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.ITagTreeManagerListener;
import com.google.security.zynamics.binnavi.API.disassembly.Tag;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagTreeManager;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TagTreeManager {
    private final ITagTreeManager m_manager;
    private final Tag m_root;
    private final Map<ITreeNode<CTag>, Tag> m_allTags = new HashMap<ITreeNode<CTag>, Tag>();
    private final InternalListener m_listener = new InternalListener();
    private final ListenerProvider<ITagTreeManagerListener> m_listeners = new ListenerProvider();

    public TagTreeManager(ITagTreeManager manager) {
        this.m_manager = manager;
        this.m_root = this.clone(manager.getRootTag(), null);
        manager.addListener(this.m_listener);
    }

    private Tag clone(ITreeNode<CTag> currentNode, Tag parentExpression) {
        Tag childExpression = new Tag(currentNode);
        this.m_allTags.put(currentNode, childExpression);
        if (parentExpression != null) {
            Tag.link(parentExpression, childExpression);
        }
        for (ITreeNode<CTag> child : currentNode.getChildren()) {
            this.clone(child, childExpression);
        }
        return childExpression;
    }

    private Tag findTag(CTag tag, Tag apiTag) {
        if (tag == apiTag.getNative().getObject()) {
            return apiTag;
        }
        for (Tag child : apiTag.getChildren()) {
            Tag foundTag = this.findTag(tag, child);
            if (foundTag == null) continue;
            return foundTag;
        }
        return null;
    }

    public void addListener(ITagTreeManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Tag addTag(Tag parent, String name) throws CouldntSaveDataException {
        try {
            if (parent == null) {
                return ObjectFinders.getObject(this.m_manager.addTag((ITreeNode<CTag>)this.m_root.getNative(), name), this.m_allTags.values());
            }
            return ObjectFinders.getObject(this.m_manager.addTag((ITreeNode<CTag>)parent.getNative(), name), this.m_allTags.values());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void deleteTag(Tag tag) throws CouldntDeleteException {
        Preconditions.checkNotNull(tag, "Error: Tag argument can not be null");
        try {
            this.m_manager.deleteTag((ITreeNode<CTag>)tag.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public List<Tag> getRootTags() {
        return this.m_root.getChildren();
    }

    public Tag getTag(CTag tag) {
        return this.findTag(tag, this.m_root);
    }

    public Tag insertTag(Tag parent, String name) throws CouldntSaveDataException {
        try {
            if (parent == null) {
                return ObjectFinders.getObject(this.m_manager.insertTag((ITreeNode<CTag>)this.m_root.getNative(), name), this.m_allTags.values());
            }
            return ObjectFinders.getObject(this.m_manager.insertTag((ITreeNode<CTag>)parent.getNative(), name), this.m_allTags.values());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void removeListener(ITagTreeManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        return "Tag Manager";
    }

    private class InternalListener
    implements com.google.security.zynamics.binnavi.Tagging.ITagTreeManagerListener {
        private InternalListener() {
        }

        private void removeTree(ITreeNode<CTag> tag) {
            TagTreeManager.this.m_allTags.remove(tag);
            for (ITreeNode<CTag> child : tag.getChildren()) {
                this.removeTree(child);
            }
        }

        @Override
        public void addedTag(ITagTreeManager manager, ITreeNode<CTag> tag) {
            Tag parentTag = (Tag)TagTreeManager.this.m_allTags.get(tag.getParent());
            Tag newTag = new Tag(tag);
            Tag.link(parentTag, newTag);
            TagTreeManager.this.m_allTags.put(tag, newTag);
            for (ITagTreeManagerListener listener : TagTreeManager.this.m_listeners) {
                try {
                    listener.addedTag(TagTreeManager.this, newTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedTag(ITagTreeManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            Tag deletedTag = (Tag)TagTreeManager.this.m_allTags.get(tag);
            Tag parentTag = deletedTag.getParent();
            List<Tag> children = deletedTag.getChildren();
            Tag.unlink(parentTag, deletedTag);
            for (Tag child : children) {
                Tag.unlink(deletedTag, child);
                Tag.link(parentTag, child);
            }
            TagTreeManager.this.m_allTags.remove(tag);
            for (ITagTreeManagerListener listener : TagTreeManager.this.m_listeners) {
                try {
                    listener.deletedTag(TagTreeManager.this, deletedTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedTagSubtree(ITagTreeManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            Tag deletedTag = (Tag)TagTreeManager.this.m_allTags.get(tag);
            Tag parentTag = deletedTag.getParent();
            Tag.unlink(parentTag, deletedTag);
            this.removeTree(tag);
            for (ITagTreeManagerListener listener : TagTreeManager.this.m_listeners) {
                try {
                    listener.deletedTagTree(TagTreeManager.this, deletedTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void insertedTag(ITagTreeManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            Tag parentTag = (Tag)TagTreeManager.this.m_allTags.get(tag.getParent());
            Tag newTag = new Tag(tag);
            for (Tag child : parentTag.getChildren()) {
                Tag.unlink(parentTag, child);
                Tag.link(newTag, child);
            }
            Tag.link(parentTag, newTag);
            TagTreeManager.this.m_allTags.put(tag, newTag);
            for (ITagTreeManagerListener listener : TagTreeManager.this.m_listeners) {
                try {
                    listener.insertedTag(TagTreeManager.this, parentTag, newTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

