/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.ITagListener;
import com.google.security.zynamics.binnavi.API.disassembly.TagType;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.ArrayList;
import java.util.List;

public final class Tag
implements ApiObject<ITreeNode<CTag>> {
    private final ITreeNode<CTag> m_tag;
    private Tag m_parent;
    private final List<Tag> m_children = new ArrayList<Tag>();
    private final InternalListener m_listener = new InternalListener();
    private final ListenerProvider<ITagListener> m_listeners = new ListenerProvider();

    Tag(ITreeNode<CTag> tag) {
        this.m_tag = Preconditions.checkNotNull(tag, "Error: Tag argument can not be null");
        this.m_tag.getObject().addListener(this.m_listener);
    }

    static void link(Tag parent, Tag child) {
        Preconditions.checkNotNull(parent, "Error: Parent can't be null");
        Preconditions.checkNotNull(child, "Error: Child can't be null");
        parent.m_children.add(child);
        child.m_parent = parent;
    }

    static void unlink(Tag parent, Tag child) {
        Preconditions.checkNotNull(parent, "Error: Parent can't be null");
        Preconditions.checkNotNull(child, "Error: Child can't be null");
        parent.m_children.remove(child);
        child.m_parent = null;
    }

    @Override
    public ITreeNode<CTag> getNative() {
        return this.m_tag;
    }

    public void addListener(ITagListener listener) {
        this.m_listeners.addListener(listener);
    }

    public List<Tag> getChildren() {
        return new ArrayList<Tag>(this.m_children);
    }

    public String getDescription() {
        return this.m_tag.getObject().getDescription();
    }

    public String getName() {
        return this.m_tag.getObject().getName();
    }

    public Tag getParent() {
        return this.m_parent;
    }

    public TagType getType() {
        return TagType.convert(this.m_tag.getObject().getType());
    }

    public void removeListener(ITagListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        try {
            this.m_tag.getObject().setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.m_tag.getObject().setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        return String.format("Tag '%s'", this.getName());
    }

    private class InternalListener
    implements com.google.security.zynamics.binnavi.Tagging.ITagListener {
        private InternalListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
            for (ITagListener listener : Tag.this.m_listeners) {
                try {
                    listener.changedDescription(Tag.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(CTag tag, String name) {
            for (ITagListener listener : Tag.this.m_listeners) {
                try {
                    listener.changedName(Tag.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedTag(CTag tag) {
        }
    }
}

