/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.AddressSpace;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DebuggerTemplate;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.IProjectListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.Trace;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewContainer;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.ProjectLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class Project
implements ApiObject<INaviProject>,
ViewContainer {
    private final Database m_database;
    private final INaviProject m_project;
    private final TagManager m_nodeTagManager;
    private final TagManager m_viewTagManager;
    private IFilledList<AddressSpace> m_addressSpaces;
    private IFilledList<View> m_views;
    private IFilledList<Trace> m_traces;
    private IFilledList<DebuggerTemplate> m_debuggerTemplates;
    private final InternalListener m_internalListener = new InternalListener();
    private final ListenerProvider<IProjectListener> m_listeners = new ListenerProvider();

    public Project(Database database, INaviProject project, TagManager nodeTagManager, TagManager viewTagManager) {
        this.m_database = Preconditions.checkNotNull(database, "Error: Database argument can't be null");
        this.m_project = Preconditions.checkNotNull(project, "Error: Project argument can't be null");
        this.m_nodeTagManager = Preconditions.checkNotNull(nodeTagManager, "Error: Node tag manager argument can't be null");
        this.m_viewTagManager = Preconditions.checkNotNull(viewTagManager, "Error: View  tag manager argument can't be null");
        if (project.isLoaded()) {
            this.convertData();
        }
        project.addListener(this.m_internalListener);
    }

    private void convertData() {
        this.m_debuggerTemplates = new FilledList<DebuggerTemplate>();
        List<DebuggerTemplate> apiTemplates = this.m_database.getDebuggerTemplateManager().getDebuggerTemplates();
        for (com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debuggerTemplate : this.m_project.getConfiguration().getDebuggers()) {
            this.m_debuggerTemplates.add(ObjectFinders.getObject(debuggerTemplate, apiTemplates));
        }
        this.m_traces = new FilledList<Trace>();
        for (TraceList trace2 : this.m_project.getContent().getTraces()) {
            this.m_traces.add(new Trace(trace2));
        }
        this.m_addressSpaces = new FilledList<AddressSpace>();
        for (INaviAddressSpace addressSpace : this.m_project.getContent().getAddressSpaces()) {
            this.m_addressSpaces.add(new AddressSpace(this.m_database, this, addressSpace));
        }
        this.m_views = new FilledList<View>();
        for (INaviView view : this.m_project.getContent().getViews()) {
            this.m_views.add(new View(this, view, this.m_nodeTagManager, this.m_viewTagManager));
        }
    }

    @Override
    public INaviProject getNative() {
        return this.m_project;
    }

    public void addDebuggerTemplate(DebuggerTemplate debuggerTemplate) throws CouldntSaveDataException {
        Preconditions.checkNotNull(debuggerTemplate, "Error: Debugger template argument can not be null");
        try {
            this.m_project.getConfiguration().addDebugger(debuggerTemplate.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void addListener(IProjectListener listener) {
        this.m_listeners.addListener(listener);
    }

    public boolean close() {
        return this.m_project.close();
    }

    public AddressSpace createAddressSpace(String name) throws CouldntSaveDataException, CouldntLoadDataException {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The address space has not yet been loaded");
        }
        try {
            CAddressSpace addressSpace = this.m_project.getContent().createAddressSpace(name);
            return ObjectFinders.getObject(addressSpace, this.m_addressSpaces);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    @Override
    public View createView(String name, String description) {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The project has not yet been loaded");
        }
        INaviView newView = this.m_project.getContent().createView(name, description);
        return ObjectFinders.getObject(newView, this.m_views);
    }

    public View createView(View view, String name, String description) throws CouldntSaveDataException {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The project has not yet been loaded");
        }
        Preconditions.checkNotNull(view, "Error: View argument can't be null");
        INaviView newView = this.m_project.getContent().createView(view.getNative(), name, description);
        return ObjectFinders.getObject(newView, this.m_views);
    }

    public boolean deleteAddressSpace(AddressSpace addressSpace) throws CouldntDeleteException {
        Preconditions.checkNotNull(addressSpace, "Error: Address space argument can not be null");
        try {
            return this.m_project.getContent().removeAddressSpace(addressSpace.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public boolean deleteView(View view) throws CouldntDeleteException {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        try {
            return this.m_project.getContent().deleteView(view.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public void dispose() {
        this.m_project.removeListener(this.m_internalListener);
    }

    public List<AddressSpace> getAddressSpaces() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The project has not yet been loaded");
        }
        return new ArrayList<AddressSpace>(this.m_addressSpaces);
    }

    public Date getCreationDate() {
        return this.m_project.getConfiguration().getCreationDate();
    }

    @Override
    public Database getDatabase() {
        return this.m_database;
    }

    public List<DebuggerTemplate> getDebuggerTemplates() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The project is not loaded");
        }
        return new ArrayList<DebuggerTemplate>(this.m_debuggerTemplates);
    }

    public String getDescription() {
        return this.m_project.getConfiguration().getDescription();
    }

    @Override
    public Function getFunction(INaviFunction function) {
        Preconditions.checkNotNull(function, "Error: Function argument can not be null");
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The project has not yet been loaded");
        }
        for (AddressSpace addressSpace : this.m_addressSpaces) {
            if (!addressSpace.isLoaded()) continue;
            for (Module module : addressSpace.getModules()) {
                Function mfunction;
                if (!module.isLoaded() || (mfunction = module.getFunction(function)) == null || mfunction.getNative() != function) continue;
                return mfunction;
            }
        }
        return null;
    }

    @Override
    public List<Function> getFunctions() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: Project is not loaded");
        }
        ArrayList<Function> list = new ArrayList<Function>();
        for (AddressSpace addressSpace : this.m_addressSpaces) {
            if (!addressSpace.isLoaded()) continue;
            for (Module module : addressSpace.getModules()) {
                if (!module.isLoaded()) continue;
                list.addAll(module.getFunctions());
            }
        }
        return new ArrayList<Function>(list);
    }

    public Date getModificationDate() {
        return this.m_project.getConfiguration().getModificationDate();
    }

    public String getName() {
        return this.m_project.getConfiguration().getName();
    }

    public List<Trace> getTraces() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The project is not loaded");
        }
        return new ArrayList<Trace>(this.m_traces);
    }

    public List<View> getViews() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: Project must be loaded first");
        }
        return new ArrayList<View>(this.m_views);
    }

    public boolean isLoaded() {
        return this.m_project.isLoaded();
    }

    public void load() throws CouldntLoadDataException {
        if (this.isLoaded()) {
            return;
        }
        try {
            this.m_project.load();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException | LoadCancelledException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public void removeDebuggerTemplate(DebuggerTemplate debuggerTemplate) throws CouldntDeleteException {
        Preconditions.checkNotNull(debuggerTemplate, "Error: Debugger template argument can not be null");
        try {
            this.m_project.getConfiguration().removeDebugger(debuggerTemplate.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public void removeListener(IProjectListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        try {
            this.m_project.getConfiguration().setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.m_project.getConfiguration().setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        StringBuilder spacesString = new StringBuilder();
        if (this.isLoaded()) {
            boolean addComma = false;
            for (AddressSpace addressSpace : this.getAddressSpaces()) {
                if (addComma) {
                    spacesString.append(", ");
                }
                addComma = true;
                spacesString.append("'");
                spacesString.append(addressSpace.getName());
                spacesString.append("'");
            }
        } else {
            spacesString.append(String.format("unloaded, %d address spaces", this.m_project.getAddressSpaceCount()));
        }
        return String.format("Project '%s' [%s]", this.getName(), spacesString);
    }

    private class InternalListener
    implements com.google.security.zynamics.binnavi.disassembly.IProjectListener {
        private InternalListener() {
        }

        @Override
        public void addedAddressSpace(INaviProject project, CAddressSpace space) {
            AddressSpace newSpace = new AddressSpace(Project.this.m_database, Project.this, space);
            Project.this.m_addressSpaces.add(newSpace);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.addedAddressSpace(Project.this, newSpace);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedDebugger(INaviProject project, com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debugger) {
            DebuggerTemplate newTemplate = ObjectFinders.getObject(debugger, Project.this.m_database.getDebuggerTemplateManager().getDebuggerTemplates());
            Project.this.m_debuggerTemplates.add(newTemplate);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.addedDebuggerTemplate(Project.this, newTemplate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedTrace(INaviProject project, TraceList trace2) {
            Trace newTrace = new Trace(trace2);
            Project.this.m_traces.add(newTrace);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.addedTrace(Project.this, newTrace);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedView(INaviProject project, INaviView view) {
            View newView = new View(Project.this, view, Project.this.m_nodeTagManager, Project.this.m_viewTagManager);
            Project.this.m_views.add(newView);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.addedView(Project.this, newView);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDescription(INaviProject project, String description) {
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.changedDescription(Project.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedModificationDate(INaviProject project, Date date) {
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.changedModificationDate(Project.this, date);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(INaviProject project, String name) {
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.changedName(Project.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void closedProject(CProject project) {
            Project.this.m_addressSpaces = null;
            Project.this.m_views = null;
            Project.this.m_traces = null;
            Project.this.m_debuggerTemplates = null;
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.closedProject(Project.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean closingProject(CProject project) {
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    if (listener.closingProject(Project.this)) continue;
                    return false;
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            return true;
        }

        @Override
        public void deletedView(INaviProject project, INaviView view) {
            View deletedView = (View)ObjectFinders.getObject(view, Project.this.m_views);
            Project.this.m_views.remove(deletedView);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.deletedView(Project.this, deletedView);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean deletingTrace(INaviProject project, TraceList trace2) {
            return true;
        }

        @Override
        public void loadedProject(CProject project) {
            Project.this.convertData();
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.loadedProject(Project.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean loading(ProjectLoadEvents event, int counter) {
            return true;
        }

        @Override
        public void removedAddressSpace(INaviProject project, INaviAddressSpace addressSpace) {
            AddressSpace deletedAddressSpace = (AddressSpace)ObjectFinders.getObject(addressSpace, Project.this.m_addressSpaces);
            Project.this.m_addressSpaces.remove(deletedAddressSpace);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.deletedAddressSpace(Project.this, deletedAddressSpace);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedDebugger(INaviProject project, com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debugger) {
            DebuggerTemplate removedTemplate = ObjectFinders.getObject(debugger, Project.this.m_database.getDebuggerTemplateManager().getDebuggerTemplates());
            Project.this.m_debuggerTemplates.remove(removedTemplate);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.removedDebuggerTemplate(Project.this, removedTemplate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedTrace(INaviProject project, TraceList trace2) {
            Trace deletedTrace = (Trace)ObjectFinders.getObject(trace2, Project.this.m_traces);
            Project.this.m_traces.remove(deletedTrace);
            for (IProjectListener listener : Project.this.m_listeners) {
                try {
                    listener.deletedTrace(Project.this, deletedTrace);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

