/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.ExpressionType;
import com.google.security.zynamics.binnavi.API.disassembly.IOperandExpressionListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Reference;
import com.google.security.zynamics.binnavi.API.disassembly.ReferenceType;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.CReference;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacement;
import com.google.security.zynamics.binnavi.disassembly.OperandDisplayStyle;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class OperandExpression
implements ApiObject<INaviOperandTreeNode> {
    private final INaviOperandTreeNode m_node;
    private final List<OperandExpression> m_children = new ArrayList<OperandExpression>();
    private OperandExpression m_parent = null;
    private final List<Reference> m_references = new ArrayList<Reference>();
    private final INaviOperandTreeNodeListener m_internalListener = new InternalOperandTreeNodeListener();
    private final ListenerProvider<IOperandExpressionListener> m_listeners = new ListenerProvider();

    public OperandExpression(INaviOperandTreeNode node) {
        this.m_node = Preconditions.checkNotNull(node, "Error: Node argument can't be null");
        for (IReference reference : this.m_node.getReferences()) {
            this.m_references.add(new Reference(reference));
        }
        this.m_node.addListener(this.m_internalListener);
    }

    public static OperandExpression create(Module module, String value, ExpressionType type) {
        return new OperandExpression(module.getNative().createOperandExpression(value, type.getNative()));
    }

    public static void link(OperandExpression parent, OperandExpression child) {
        Preconditions.checkNotNull(parent, "Error: Parent argument can't be null");
        Preconditions.checkNotNull(child, "Error: Child argument can't be null");
        parent.m_children.add(child);
        child.m_parent = parent;
    }

    @Override
    public INaviOperandTreeNode getNative() {
        return this.m_node;
    }

    public void addListener(IOperandExpressionListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Reference addReference(Address address, ReferenceType type) throws CouldntSaveDataException {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        Preconditions.checkNotNull(type, "Error: Type argument can not be null");
        try {
            CReference reference = new CReference(new CAddress(address.toLong()), type.getNative());
            this.m_node.addReference(reference);
            return ObjectFinders.getObject(reference, this.m_references);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void deleteReference(Reference reference) throws CouldntDeleteException {
        Preconditions.checkNotNull(reference, "Error: Reference argument can not be null");
        try {
            this.m_node.deleteReference(reference.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public List<OperandExpression> getChildren() {
        return new ArrayList<OperandExpression>(this.m_children);
    }

    public OperandExpression getParent() {
        return this.m_parent;
    }

    public List<Reference> getReferences() {
        return new ArrayList<Reference>(this.m_references);
    }

    public String getReplacement() {
        INaviReplacement replacement = this.m_node.getReplacement();
        return replacement == null ? null : replacement.toString();
    }

    public ExpressionType getType() {
        return ExpressionType.convert(this.m_node.getType());
    }

    public String getValue() {
        return this.m_node.getValue();
    }

    public void removeListener(IOperandExpressionListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        return this.getValue();
    }

    private class InternalOperandTreeNodeListener
    implements INaviOperandTreeNodeListener {
        private InternalOperandTreeNodeListener() {
        }

        @Override
        public void addedReference(INaviOperandTreeNode operandTreeNode, IReference reference) {
            Reference newReference = new Reference(reference);
            OperandExpression.this.m_references.add(newReference);
            for (IOperandExpressionListener listener : OperandExpression.this.m_listeners) {
                try {
                    listener.addedReference(OperandExpression.this, newReference);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDisplayStyle(COperandTreeNode operandTreeNode, OperandDisplayStyle style) {
        }

        @Override
        public void changedValue(INaviOperandTreeNode operandTreeNode) {
            for (IOperandExpressionListener listener : OperandExpression.this.m_listeners) {
                try {
                    listener.changed(OperandExpression.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedReference(INaviOperandTreeNode operandTreeNode, IReference reference) {
            Reference removedReference = (Reference)ObjectFinders.getObject(reference, OperandExpression.this.m_references);
            OperandExpression.this.m_references.remove(removedReference);
            for (IOperandExpressionListener listener : OperandExpression.this.m_listeners) {
                try {
                    listener.removedReference(OperandExpression.this, removedReference);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

