/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.OperandExpression;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;

public final class Operand
implements ApiObject<COperandTree> {
    private final OperandExpression m_root;
    private final COperandTree m_operand;

    public Operand(COperandTree operand) {
        this.m_operand = Preconditions.checkNotNull(operand, "Error: Operand argument can't be null");
        this.m_root = this.clone(operand.getRootNode(), null);
    }

    public static Operand create(Module module, OperandExpression root) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        Preconditions.checkNotNull(root, "Error: Root argument can not be null");
        COperandTree opTree = module.getNative().createOperand((COperandTreeNode)root.getNative());
        return new Operand(opTree);
    }

    private OperandExpression clone(INaviOperandTreeNode currentNode, OperandExpression parentExpression) {
        OperandExpression childExpression = new OperandExpression(currentNode);
        if (parentExpression != null) {
            OperandExpression.link(parentExpression, childExpression);
        }
        for (INaviOperandTreeNode child : currentNode.getChildren()) {
            this.clone(child, childExpression);
        }
        return childExpression;
    }

    @Override
    public COperandTree getNative() {
        return this.m_operand;
    }

    public OperandExpression getRootNode() {
        return this.m_root;
    }

    public String toString() {
        return this.m_operand.toString();
    }
}

