/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.Callgraph;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DebuggerTemplate;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionBlock;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionEdge;
import com.google.security.zynamics.binnavi.API.disassembly.IModuleListener;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.Trace;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewContainer;
import com.google.security.zynamics.binnavi.API.disassembly.ViewType;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.CCallgraph;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphEdge;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphNode;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CTraceContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.ITraceContainerListener;
import com.google.security.zynamics.binnavi.disassembly.Modules.ModuleInitializeEvents;
import com.google.security.zynamics.binnavi.disassembly.Modules.ModuleLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Module
implements ApiObject<INaviModule>,
ViewContainer {
    private final Database m_database;
    private final INaviModule m_module;
    private final TagManager m_nodeTagManager;
    private final TagManager m_viewTagManager;
    private Callgraph m_callgraph;
    private List<Function> m_functions;
    private List<View> m_views;
    private Debugger m_debugger;
    private DebuggerTemplate m_debuggerTemplate;
    private List<Trace> m_traces;
    private final ListenerProvider<IModuleListener> m_listeners = new ListenerProvider();
    private final InternalModuleListener m_listener = new InternalModuleListener();
    private final Map<INaviFunction, Function> m_functionMap = new HashMap<INaviFunction, Function>();
    private final ITraceContainerListener m_traceListener = new InternalTraceListener();

    public Module(Database database, INaviModule module, TagManager nodeTagManager, TagManager viewTagManager) {
        this.m_database = Preconditions.checkNotNull(database, "Error: Database argument can't be null");
        this.m_module = Preconditions.checkNotNull(module, "Error: Module argument can't be null");
        this.m_nodeTagManager = Preconditions.checkNotNull(nodeTagManager, "Error: Node tag manager argument can't be null");
        this.m_viewTagManager = Preconditions.checkNotNull(viewTagManager, "Error: View tag manager argument can't be null");
        if (this.m_module.getConfiguration().getDebugger() != null) {
            this.m_debugger = new Debugger(this.m_module.getConfiguration().getDebugger());
        }
        if (module.isLoaded()) {
            this.convertData();
        }
        module.addListener(this.m_listener);
    }

    public Trace createTrace(String name, String description) throws CouldntSaveDataException {
        try {
            return new Trace(this.m_module.getContent().getTraceContainer().createTrace(name, description));
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    private void convertData() {
        this.m_traces = new ArrayList<Trace>();
        for (TraceList traceList : this.m_module.getContent().getTraceContainer().getTraces()) {
            this.m_traces.add(new Trace(traceList));
        }
        this.m_module.getContent().getTraceContainer().addListener(this.m_traceListener);
        this.m_functions = new ArrayList<Function>();
        for (INaviFunction iNaviFunction : this.m_module.getContent().getFunctionContainer().getFunctions()) {
            this.m_functions.add(new Function(this, iNaviFunction));
        }
        for (Function function : this.m_functions) {
            this.m_functionMap.put(function.getNative(), function);
        }
        this.m_views = new ArrayList<View>();
        for (INaviView iNaviView : this.m_module.getContent().getViewContainer().getViews()) {
            this.m_views.add(new View(this, iNaviView, this.m_nodeTagManager, this.m_viewTagManager));
        }
        this.createCallgraph();
    }

    private void createCallgraph() {
        CCallgraph graph = this.m_module.getContent().getNativeCallgraph();
        ArrayList<FunctionBlock> blocks = new ArrayList<FunctionBlock>();
        ArrayList<FunctionEdge> edges = new ArrayList<FunctionEdge>();
        HashMap<ICallgraphNode, FunctionBlock> blockMap = new HashMap<ICallgraphNode, FunctionBlock>();
        HashMap<INaviFunction, Function> functionMap = new HashMap<INaviFunction, Function>();
        for (Function function : this.m_functions) {
            functionMap.put(function.getNative(), function);
        }
        for (ICallgraphNode block : graph.getNodes()) {
            FunctionBlock newBlock = new FunctionBlock((Function)functionMap.get(block.getFunction()));
            blockMap.put(block, newBlock);
            blocks.add(newBlock);
        }
        for (ICallgraphEdge edge : graph.getEdges()) {
            FunctionBlock source = (FunctionBlock)blockMap.get(edge.getSource());
            FunctionBlock target = (FunctionBlock)blockMap.get(edge.getTarget());
            edges.add(new FunctionEdge(source, target));
        }
        this.m_callgraph = new Callgraph((List<FunctionBlock>)blocks, (List<FunctionEdge>)edges);
    }

    @Override
    public INaviModule getNative() {
        return this.m_module;
    }

    public void addListener(IModuleListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void close() {
        this.m_module.close();
    }

    @Override
    public View createView(String name, String description) {
        CView newView = this.m_module.getContent().getViewContainer().createView(name, description);
        return ObjectFinders.getObject(newView, this.m_views);
    }

    public void deleteView(View view) throws CouldntDeleteException {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        if (view.getType() == ViewType.Native) {
            throw new IllegalArgumentException("Error: Native views can not be deleted");
        }
        if (!this.isLoaded()) {
            throw new IllegalArgumentException("Error: Module must be opened before views can be deleted");
        }
        if (!this.m_views.contains(view)) {
            throw new IllegalArgumentException("Error: View does not belong to this module");
        }
        try {
            this.m_module.getContent().getViewContainer().deleteView(view.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public void dispose() {
        this.m_module.removeListener(this.m_listener);
    }

    public Callgraph getCallgraph() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The module is not loaded");
        }
        return this.m_callgraph;
    }

    public Date getCreationDate() {
        return this.m_module.getConfiguration().getCreationDate();
    }

    @Override
    public Database getDatabase() {
        return this.m_database;
    }

    public Debugger getDebugger() {
        return this.m_debugger;
    }

    public DebuggerTemplate getDebuggerTemplate() {
        return this.m_debuggerTemplate;
    }

    public String getDescription() {
        return this.m_module.getConfiguration().getDescription();
    }

    public Address getFilebase() {
        return new Address(this.m_module.getConfiguration().getFileBase().toBigInteger());
    }

    @Override
    public Function getFunction(INaviFunction function) {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The module is not loaded");
        }
        return this.m_functionMap.get(function);
    }

    public Function getFunction(View view) {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        if (!this.m_views.contains(view)) {
            throw new IllegalArgumentException("Error: View is not part of this module");
        }
        if (view.getType() != ViewType.Native) {
            throw new IllegalArgumentException("Error: View is not a native view");
        }
        return this.m_functionMap.get(this.m_module.getContent().getViewContainer().getFunction(view.getNative()));
    }

    @Override
    public List<Function> getFunctions() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The module is not loaded");
        }
        return new ArrayList<Function>(this.m_functions);
    }

    public int getId() {
        return this.m_module.getConfiguration().getId();
    }

    public Address getImagebase() {
        return new Address(this.m_module.getConfiguration().getImageBase().toBigInteger());
    }

    public String getMD5() {
        return this.m_module.getConfiguration().getMD5();
    }

    public Date getModificationDate() {
        return this.m_module.getConfiguration().getModificationDate();
    }

    public String getName() {
        return this.m_module.getConfiguration().getName();
    }

    public String getSHA1() {
        return this.m_module.getConfiguration().getSha1();
    }

    public List<Trace> getTraces() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The module is not loaded");
        }
        return new ArrayList<Trace>(this.m_traces);
    }

    public List<View> getViews() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: The module is not loaded");
        }
        return new ArrayList<View>(this.m_views);
    }

    public void initialize() throws CouldntSaveDataException {
        try {
            this.getNative().initialize();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public boolean isInitialized() {
        return this.getNative().isInitialized();
    }

    public boolean isLoaded() {
        return this.m_module.isLoaded();
    }

    public void load() throws CouldntLoadDataException {
        if (this.isLoaded()) {
            return;
        }
        try {
            this.m_module.load();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException | LoadCancelledException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public void removeListener(IModuleListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDebuggerTemplate(DebuggerTemplate template) throws CouldntSaveDataException {
        try {
            this.m_module.getConfiguration().setDebuggerTemplate(template == null ? null : template.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        try {
            this.m_module.getConfiguration().setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setFilebase(Address address) throws CouldntSaveDataException {
        try {
            this.m_module.getConfiguration().setFileBase(new CAddress(address.toLong()));
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setImagebase(Address address) throws CouldntSaveDataException {
        try {
            this.m_module.getConfiguration().setImageBase(new CAddress(address.toLong()));
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.m_module.getConfiguration().setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        return String.format("Module '%s'", this.getName());
    }

    private class InternalTraceListener
    implements ITraceContainerListener {
        private InternalTraceListener() {
        }

        @Override
        public void addedTrace(CTraceContainer container, TraceList trace2) {
            Trace newTrace = new Trace(trace2);
            Module.this.m_traces.add(newTrace);
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.addedTrace(Module.this, newTrace);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedTrace(CTraceContainer container, TraceList trace2) {
            Trace deletedTrace = (Trace)ObjectFinders.getObject(trace2, Module.this.m_traces);
            Module.this.m_traces.remove(deletedTrace);
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.deletedTrace(Module.this, deletedTrace);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    private class InternalModuleListener
    implements com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            View newView = new View(Module.this, view, Module.this.m_nodeTagManager, Module.this.m_viewTagManager);
            Module.this.m_views.add(newView);
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.addedView(Module.this, newView);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedData(CModule module, byte[] data) {
        }

        @Override
        public void changedDebugger(INaviModule module, IDebugger debugger) {
            Module.this.m_debugger = debugger == null ? null : new Debugger(debugger);
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedDebugger(Module.this, Module.this.m_debugger);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDebuggerTemplate(INaviModule module, com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate template) {
            DebuggerTemplate newTemplate = template == null ? null : ObjectFinders.getObject(template, Module.this.m_database.getDebuggerTemplateManager().getDebuggerTemplates());
            Module.this.m_debuggerTemplate = newTemplate;
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedDebuggerTemplate(Module.this, newTemplate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDescription(INaviModule module, String description) {
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedDescription(Module.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedFileBase(INaviModule module, IAddress fileBase) {
            Address newAddress = new Address(fileBase.toBigInteger());
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedFilebase(Module.this, newAddress);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedImageBase(INaviModule module, IAddress imageBase) {
            Address newAddress = new Address(imageBase.toBigInteger());
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedImagebase(Module.this, newAddress);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedModificationDate(INaviModule module, Date date) {
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedModificationDate(Module.this, date);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(INaviModule module, String name) {
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.changedName(Module.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedStarState(INaviModule module, boolean isStared) {
        }

        @Override
        public void closedModule(CModule module, ICallgraphView callgraphView, List<IFlowgraphView> flowgraphs) {
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.closedModule(Module.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean closingModule(CModule module) {
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    if (listener.closingModule(Module.this)) continue;
                    return false;
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            return true;
        }

        @Override
        public void deletedView(INaviModule module, INaviView view) {
            View deletedView = (View)ObjectFinders.getObject(view, Module.this.m_views);
            Module.this.m_views.remove(deletedView);
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.deletedView(Module.this, deletedView);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean initializing(ModuleInitializeEvents event, int counter) {
            return true;
        }

        @Override
        public void loadedModule(INaviModule module) {
            Module.this.convertData();
            for (IModuleListener listener : Module.this.m_listeners) {
                try {
                    listener.loadedModule(Module.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean loading(ModuleLoadEvents event, int counter) {
            return true;
        }

        @Override
        public void initializedModule(INaviModule module) {
        }
    }
}

