/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.IFunctionNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class FunctionNode
extends ViewNode {
    private final INaviFunctionNode m_node;
    private final Function m_function;
    private final ListenerProvider<IFunctionNodeListener> m_listeners = new ListenerProvider();

    public FunctionNode(View view, INaviFunctionNode node, Function function, TagManager tagManager) {
        super(view, node, tagManager);
        this.m_function = Preconditions.checkNotNull(function, "Error: Function argument can not be null");
        this.m_node = node;
    }

    protected ListenerProvider<IFunctionNodeListener> getFunctionListeners() {
        return this.m_listeners;
    }

    @Override
    protected String getName() {
        return this.toString();
    }

    public void addListener(IFunctionNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public List<IComment> appendComment(String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        ArrayList<IComment> comments = new ArrayList<IComment>();
        try {
            comments.addAll(this.m_node.appendLocalFunctionComment(comment));
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
        for (IFunctionNodeListener listener : this.m_listeners) {
            try {
                listener.appendedComment(this, Iterables.getLast(comments));
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return comments;
    }

    public void deleteComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_node.deleteLocalFunctionComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
        for (IFunctionNodeListener listener : this.m_listeners) {
            try {
                listener.deletedComment(this, comment);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public IComment editComment(IComment comment, String commentText) throws CouldntSaveDataException {
        IComment editedComment = null;
        try {
            editedComment = this.m_node.editLocalFunctionComment(comment, commentText);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        for (IFunctionNodeListener listener : this.m_listeners) {
            try {
                listener.editedComment(this, editedComment);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return editedComment;
    }

    public List<?> getComment() {
        return this.m_node.getLocalFunctionComment();
    }

    public Function getFunction() {
        return this.m_function;
    }

    public void initializeComment(ArrayList<IComment> comments) {
        this.m_node.initializeLocalFunctionComment(comments);
        for (IFunctionNodeListener listener : this.m_listeners) {
            try {
                listener.initializedComment(this, comments);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeListener(IFunctionNodeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public String toString() {
        return String.format("Function Node ['%s']", this.m_node.getFunction().getName());
    }
}

