/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.IGraphNode;
import java.util.ArrayList;
import java.util.List;

public final class FunctionBlock
implements IGraphNode<FunctionBlock> {
    private final Function m_function;
    private final List<FunctionBlock> m_children = new ArrayList<FunctionBlock>();
    private final List<FunctionBlock> m_parents = new ArrayList<FunctionBlock>();

    FunctionBlock(Function function) {
        this.m_function = Preconditions.checkNotNull(function, "Error: Function argument can not be null");
    }

    static void link(FunctionBlock parent, FunctionBlock child) {
        Preconditions.checkNotNull(parent, "Error: Parent argument can not be null");
        Preconditions.checkNotNull(child, "Error: Child argument can not be null");
        parent.m_children.add(child);
        child.m_parents.add(parent);
    }

    @Override
    public List<FunctionBlock> getChildren() {
        return new ArrayList<FunctionBlock>(this.m_children);
    }

    public Function getFunction() {
        return this.m_function;
    }

    @Override
    public List<FunctionBlock> getParents() {
        return new ArrayList<FunctionBlock>(this.m_parents);
    }

    public String toString() {
        return String.format("Function Block ['%s']", this.m_function.toString());
    }
}

