/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.IDatabaseManagerListener;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.DatabaseManagerListener;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseManager;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DatabaseManager
implements Iterable<Database>,
ApiObject<IDatabaseManager> {
    private final IDatabaseManager m_manager;
    private final List<Database> m_databases = new ArrayList<Database>();
    private final ListenerProvider<IDatabaseManagerListener> m_listeners = new ListenerProvider();
    private final InternalDatabaseListener m_internalListener = new InternalDatabaseListener();

    public DatabaseManager(IDatabaseManager manager) {
        Preconditions.checkNotNull(manager, "Error: Manager argument can't be null");
        this.m_manager = manager;
        for (IDatabase database : this.m_manager) {
            this.m_databases.add(new Database(database));
        }
        manager.addListener(this.m_internalListener);
    }

    @Override
    public IDatabaseManager getNative() {
        return this.m_manager;
    }

    public Database addDatabase(String description, String driver, String host, String name, String user2, String password, String identity, boolean savePassword, boolean autoConnect) {
        Preconditions.checkNotNull(description, "Error: description argument can not be null");
        Preconditions.checkNotNull(driver, "Error: driver argument can not be null");
        Preconditions.checkNotNull(host, "Error: host argument can not be null");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        IDatabase newDatabase = this.m_manager.addDatabase(new CDatabase(description, driver, host, name, user2, password, identity, savePassword, autoConnect));
        return ObjectFinders.getObject(newDatabase, this.m_databases);
    }

    public void addListener(IDatabaseManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public List<Database> getDatabases() {
        return new ArrayList<Database>(this.m_databases);
    }

    @Override
    public Iterator<Database> iterator() {
        return this.m_databases.iterator();
    }

    public void removeDatabase(Database database) {
        Preconditions.checkNotNull(database, "Error: Database argument can not be null");
        this.m_manager.removeDatabase(database.getNative());
    }

    public void removeListener(IDatabaseManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        StringBuffer databaseString = new StringBuffer();
        boolean addComma = false;
        for (Database database : this.getDatabases()) {
            if (addComma) {
                databaseString.append(", ");
            }
            addComma = true;
            String string2 = database.getDescription();
            databaseString.append(new StringBuilder(2 + String.valueOf(string2).length()).append("'").append(string2).append("'").toString());
        }
        return String.format("Database Manager [%s]", databaseString);
    }

    private class InternalDatabaseListener
    implements DatabaseManagerListener {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedDatabase(IDatabaseManager databaseManager, IDatabase database) {
            Database newDatabase = new Database(database);
            DatabaseManager.this.m_databases.add(newDatabase);
            for (IDatabaseManagerListener listener : DatabaseManager.this.m_listeners) {
                try {
                    listener.addedDatabase(DatabaseManager.this, newDatabase);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedDatabase(IDatabaseManager databaseManager, IDatabase database) {
            Database removedDatabase = (Database)ObjectFinders.getObject(database, DatabaseManager.this.m_databases);
            removedDatabase.dispose();
            DatabaseManager.this.m_databases.remove(removedDatabase);
            for (IDatabaseManagerListener listener : DatabaseManager.this.m_listeners) {
                try {
                    listener.removedDatabase(DatabaseManager.this, removedDatabase);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void reorderedDatabases(IDatabaseManager databaseManager, IDatabase database, int index) {
        }
    }
}

