/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntConnectException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntInitializeDatabaseException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.API.disassembly.IDatabaseListener;
import com.google.security.zynamics.binnavi.API.disassembly.ImportFailedException;
import com.google.security.zynamics.binnavi.API.disassembly.InvalidDatabaseException;
import com.google.security.zynamics.binnavi.API.disassembly.InvalidDatabaseFormatException;
import com.google.security.zynamics.binnavi.API.disassembly.InvalidDatabaseVersionException;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidExporterDatabaseFormatException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.LoadEvents;
import com.google.security.zynamics.binnavi.Importers.CBinExportImporter;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class Database
implements ApiObject<IDatabase> {
    private final IDatabase m_database;
    private final List<Module> m_modules = new ArrayList<Module>();
    private final List<Project> m_projects = new ArrayList<Project>();
    private TagManager m_viewTagManager;
    private TagManager m_nodeTagManager;
    private DebuggerTemplateManager m_debuggerTemplateManager;
    private final ListenerProvider<IDatabaseListener> m_listeners = new ListenerProvider();
    private final InternalDatabaseListener m_internalListener = new InternalDatabaseListener();

    public Database(IDatabase database) {
        Preconditions.checkNotNull(database, "Error: Database argument can't be null");
        this.m_database = database;
        if (database.isLoaded()) {
            this.convertData();
        }
        database.addListener(this.m_internalListener);
    }

    private void convertData() {
        this.m_viewTagManager = new TagManager(this.m_database.getContent().getViewTagManager());
        this.m_nodeTagManager = new TagManager(this.m_database.getContent().getNodeTagManager());
        this.m_modules.clear();
        this.m_projects.clear();
        for (INaviModule module : this.m_database.getContent().getModules()) {
            this.m_modules.add(new Module(this, module, this.m_nodeTagManager, this.m_viewTagManager));
        }
        for (INaviProject project : this.m_database.getContent().getProjects()) {
            this.m_projects.add(new Project(this, project, this.m_nodeTagManager, this.m_viewTagManager));
        }
        this.m_debuggerTemplateManager = new DebuggerTemplateManager(this.m_database.getContent().getDebuggerTemplateManager());
    }

    private void disposedLoadedObjects() {
        if (this.m_modules != null) {
            for (Module module : this.m_modules) {
                module.dispose();
            }
            for (Project project : this.m_projects) {
                project.dispose();
            }
            if (this.m_debuggerTemplateManager != null) {
                this.m_debuggerTemplateManager.dispose();
            }
            this.m_viewTagManager = null;
            this.m_nodeTagManager = null;
            this.m_modules.clear();
            this.m_projects.clear();
            this.m_debuggerTemplateManager = null;
        }
    }

    @Override
    public IDatabase getNative() {
        return this.m_database;
    }

    public void addListener(IDatabaseListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void close() {
        this.m_database.close();
    }

    public void connect() throws CouldntLoadDriverException, CouldntConnectException, InvalidDatabaseException, CouldntInitializeDatabaseException, InvalidDatabaseFormatException {
        try {
            this.m_database.connect();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException e2) {
            throw new CouldntLoadDriverException(e2);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntConnectException | LoadCancelledException e3) {
            throw new CouldntConnectException(e3);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseException e4) {
            throw new InvalidDatabaseException(e4);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntInitializeDatabaseException e5) {
            throw new CouldntInitializeDatabaseException(e5);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseVersionException | InvalidExporterDatabaseFormatException e6) {
            throw new InvalidDatabaseFormatException(e6);
        }
    }

    public Project createProject(String name) throws CouldntSaveDataException {
        try {
            INaviProject newProject = this.m_database.getContent().addProject(name);
            return ObjectFinders.getObject(newProject, this.m_projects);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void deleteModule(Module module) throws CouldntDeleteException {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        try {
            this.m_database.getContent().delete(module.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public void deleteProject(Project project) throws CouldntDeleteException {
        Preconditions.checkNotNull(project, "Error: Project argument can not be null");
        try {
            this.m_database.getContent().delete(project.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public void dispose() {
        this.m_database.removeListener(this.m_internalListener);
        this.disposedLoadedObjects();
    }

    public ResultSet executeQuery(PreparedStatement statement) throws SQLException {
        Preconditions.checkNotNull(statement, "Statement argument can not be null");
        return statement.executeQuery();
    }

    public ResultSet executeQuery(String query) throws SQLException {
        Preconditions.checkNotNull(query, "Query argument can not be null");
        return this.m_database.executeQuery(query);
    }

    public DebuggerTemplateManager getDebuggerTemplateManager() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: Database must be loaded first");
        }
        return this.m_debuggerTemplateManager;
    }

    public String getDescription() {
        return this.m_database.getConfiguration().getDescription();
    }

    public String getDriver() {
        return this.m_database.getConfiguration().getDriver();
    }

    public String getHost() {
        return this.m_database.getConfiguration().getHost();
    }

    public List<Module> getModules() {
        if (!this.isLoaded()) {
            try {
                this.load();
            }
            catch (CouldntLoadDataException | InvalidDatabaseVersionException e2) {
                return new ArrayList<Module>();
            }
        }
        return new ArrayList<Module>(this.m_modules);
    }

    public String getName() {
        return this.m_database.getConfiguration().getName();
    }

    public TagManager getNodeTagManager() {
        if (!this.isLoaded()) {
            throw new IllegalArgumentException("Error: The database is not loaded yet");
        }
        return this.m_nodeTagManager;
    }

    public String getPassword() {
        return this.m_database.getConfiguration().getPassword();
    }

    public List<Project> getProjects() {
        if (!this.isLoaded()) {
            try {
                this.load();
            }
            catch (CouldntLoadDataException | InvalidDatabaseVersionException e2) {
                return new ArrayList<Project>();
            }
        }
        return new ArrayList<Project>(this.m_projects);
    }

    public String getUrl() {
        return this.m_database.getConfiguration().getUrl();
    }

    public String getUser() {
        return this.m_database.getConfiguration().getUser();
    }

    public TagManager getViewTagManager() {
        if (!this.isLoaded()) {
            throw new IllegalArgumentException("Error: The database is not loaded yet");
        }
        return this.m_viewTagManager;
    }

    public void importIDB(String idbfile) throws ImportFailedException {
        try {
            new CBinExportImporter().importIdbFile(ConfigManager.instance().getGeneralSettings().getIdaDirectory(), idbfile, this.m_database);
        }
        catch (com.google.security.zynamics.binnavi.Importers.ImportFailedException e2) {
            throw new ImportFailedException(e2);
        }
    }

    public boolean isAutoConnect() {
        return this.m_database.getConfiguration().isAutoConnect();
    }

    public boolean isConnected() {
        return this.m_database.isConnected();
    }

    public boolean isLoaded() {
        return this.m_database.isLoaded();
    }

    public boolean isSavePassword() {
        return this.m_database.getConfiguration().isSavePassword();
    }

    public void load() throws CouldntLoadDataException, InvalidDatabaseVersionException {
        try {
            this.m_database.load();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException | LoadCancelledException e2) {
            throw new CouldntLoadDataException(e2);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseVersionException e3) {
            throw new InvalidDatabaseVersionException(e3);
        }
    }

    public void refresh() throws CouldntLoadDataException {
        try {
            this.m_database.getContent().refreshRawModules();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public void removeListener(IDatabaseListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setAutoConnect(boolean autoConnect) {
        this.m_database.getConfiguration().setAutoConnect(autoConnect);
    }

    public void setDescription(String description) {
        this.m_database.getConfiguration().setDescription(description);
    }

    public void setDriver(String driver) {
        this.m_database.getConfiguration().setDriver(driver);
    }

    public void setHost(String host) {
        this.m_database.getConfiguration().setHost(host);
    }

    public void setName(String name) {
        this.m_database.getConfiguration().setName(name);
    }

    public void setPassword(String password) {
        this.m_database.getConfiguration().setPassword(password);
    }

    public void setSavePassword(boolean savePassword) {
        this.m_database.getConfiguration().setSavePassword(savePassword);
    }

    public void setUser(String user2) {
        this.m_database.getConfiguration().setUser(user2);
    }

    public String toString() {
        if (this.isLoaded()) {
            return String.format("Database '%s' [%d projects, %d modules]", this.getDescription(), this.getProjects().size(), this.getModules().size());
        }
        return String.format("Database '%s' [Unloaded]", this.getDescription());
    }

    private class InternalDatabaseListener
    implements com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseListener {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedModule(IDatabase database, INaviModule module) {
            Module newModule = new Module(Database.this, module, Database.this.m_nodeTagManager, Database.this.m_viewTagManager);
            Database.this.m_modules.add(newModule);
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.addedModule(Database.this, newModule);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedProject(IDatabase connection, INaviProject project) {
            Project newProject = new Project(Database.this, project, Database.this.m_nodeTagManager, Database.this.m_viewTagManager);
            Database.this.m_projects.add(newProject);
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.addedProject(Database.this, newProject);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedAutoConnect(IDatabase database, boolean autoConnect) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedAutoConnect(Database.this, autoConnect);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDescription(IDatabase database, String description) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedDescription(Database.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDriver(IDatabase database, String driver) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedDriver(Database.this, driver);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedHost(IDatabase database, String host) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedHost(Database.this, host);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedIdentity(IDatabase database, String identity) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedIdentity(Database.this, identity);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(IDatabase database, String name) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedName(Database.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedPassword(IDatabase database, String password) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedPassword(Database.this, password);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedRawModules(IDatabase database, List<INaviRawModule> oldModules, List<INaviRawModule> newModules) {
        }

        @Override
        public void changedSavePassword(IDatabase database, boolean savePassword) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedSavePassword(Database.this, savePassword);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedUser(IDatabase database, String user2) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.changedUser(Database.this, user2);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void closedDatabase(IDatabase connection) {
            Database.this.disposedLoadedObjects();
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.closedDatabase(Database.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean closingDatabase(IDatabase database) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    if (listener.closingDatabase(Database.this)) continue;
                    return false;
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            return true;
        }

        @Override
        public void deletedModule(IDatabase database, INaviModule module) {
            Module deletedModule = (Module)ObjectFinders.getObject(module, Database.this.m_modules);
            deletedModule.dispose();
            Database.this.m_modules.remove(deletedModule);
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.deletedModule(Database.this, deletedModule);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedProject(IDatabase database, INaviProject project) {
            Project deletedProject = (Project)ObjectFinders.getObject(project, Database.this.m_projects);
            deletedProject.dispose();
            Database.this.m_projects.remove(deletedProject);
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.deletedProject(Database.this, deletedProject);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedRawModule(IDatabase database, INaviRawModule module) {
        }

        @Override
        public void loadedDatabase(IDatabase database) {
            Database.this.convertData();
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.loadedDatabase(Database.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean loading(LoadEvents event, int counter) {
            return true;
        }

        @Override
        public void openedDatabase(IDatabase connection) {
            for (IDatabaseListener listener : Database.this.m_listeners) {
                try {
                    listener.openedDatabase(Database.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

