/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.IGraphNode;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.reil.InternalTranslationException;
import com.google.security.zynamics.binnavi.API.reil.ReilGraph;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.REIL.InstructionFinders;
import com.google.security.zynamics.binnavi.REIL.ReilGraphConverter;
import com.google.security.zynamics.binnavi.disassembly.IBlockNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BasicBlock
implements Iterable<Instruction>,
IGraphNode<BasicBlock>,
ApiObject<IBlockNode> {
    private final IBlockNode m_block;
    private final Function m_parentFunction;
    private final List<Instruction> m_instructions = new ArrayList<Instruction>();
    private final List<BasicBlock> m_children = new ArrayList<BasicBlock>();
    private final List<BasicBlock> m_parents = new ArrayList<BasicBlock>();
    private final ReilTranslator<INaviInstruction> m_translator = new ReilTranslator();
    private ReilGraph m_reilGraph = null;

    public BasicBlock(IBlockNode block, Function parentFunction) {
        this.m_block = Preconditions.checkNotNull(block, "Error: Block argument can't be null");
        this.m_parentFunction = Preconditions.checkNotNull(parentFunction, "Error: Parent function argument can't be null");
        for (INaviInstruction instruction : this.m_block.getBlock().getInstructions()) {
            this.m_instructions.add(new Instruction(instruction));
        }
        if (this.m_instructions.isEmpty()) {
            throw new IllegalArgumentException("Error: Block without instructions can not exist.");
        }
    }

    static void link(BasicBlock parent, BasicBlock child) {
        parent.m_children.add(child);
        child.m_parents.add(parent);
    }

    @Override
    public IBlockNode getNative() {
        return this.m_block;
    }

    public Address getAddress() {
        return new Address(this.m_block.getBlock().getAddress().toBigInteger());
    }

    @Override
    public List<BasicBlock> getChildren() {
        return new ArrayList<BasicBlock>(this.m_children);
    }

    public String getComment() {
        return this.m_block.getBlock().getGlobalComment();
    }

    public List<Instruction> getInstructions() {
        return new ArrayList<Instruction>(this.m_instructions);
    }

    public Function getParentFunction() {
        return this.m_parentFunction;
    }

    @Override
    public List<BasicBlock> getParents() {
        return new ArrayList<BasicBlock>(this.m_parents);
    }

    public ReilGraph getReilCode() throws InternalTranslationException {
        if (this.m_reilGraph == null) {
            try {
                this.m_reilGraph = ReilGraphConverter.createReilGraph(this.m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), (INaviInstruction)((Object)this.m_block)));
            }
            catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
                throw new InternalTranslationException(e2, InstructionFinders.findInstruction(this, e2.getInstruction()));
            }
        }
        return this.m_reilGraph;
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this.m_instructions.iterator();
    }

    public String toString() {
        StringBuilder blockString = new StringBuilder();
        for (Instruction instruction : this.m_instructions) {
            blockString.append(instruction.toString());
            blockString.append('\n');
        }
        return blockString.toString();
    }
}

