/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DebuggerTemplate;
import com.google.security.zynamics.binnavi.API.disassembly.IAddressSpaceListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.AddressSpaceLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceConfigurationListener;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class AddressSpace
implements ApiObject<INaviAddressSpace> {
    private final Database m_database;
    private final Project m_project;
    private final INaviAddressSpace m_addressSpace;
    private List<Module> m_modules;
    private Debugger m_debugger;
    private final ListenerProvider<IAddressSpaceListener> m_listeners = new ListenerProvider();
    private final InternalListener m_listener = new InternalListener();
    private final InternalConfigurationListener m_configurationListener = new InternalConfigurationListener();
    private final IAddressSpaceContentListener m_internalContentListener = new InternalContentListener();

    public AddressSpace(Database database, Project project, INaviAddressSpace addressSpace) {
        Preconditions.checkNotNull(database, "Error: Database argument can't be null");
        Preconditions.checkNotNull(addressSpace, "Error: Address space argument can't be null");
        this.m_database = database;
        this.m_project = project;
        this.m_addressSpace = addressSpace;
        Debugger debugger = this.m_debugger = this.m_addressSpace.getConfiguration().getDebugger() == null ? null : new Debugger(this.m_addressSpace.getConfiguration().getDebugger());
        if (addressSpace.isLoaded()) {
            this.convertData();
        }
        addressSpace.addListener(this.m_listener);
        addressSpace.getConfiguration().addListener(this.m_configurationListener);
    }

    private Module addModule(INaviModule module) {
        Module apiModule = null;
        apiModule = ObjectFinders.getObject(module, this.m_database.getModules());
        if (apiModule == null) {
            NaviLogger.severe("Error: Could not determine API module for native module '%s'", module.getConfiguration().getName());
        } else {
            this.m_modules.add(apiModule);
        }
        return apiModule;
    }

    private void convertData() {
        this.m_addressSpace.getContent().addListener(this.m_internalContentListener);
        this.m_modules = new ArrayList<Module>();
        for (INaviModule module : this.m_addressSpace.getContent().getModules()) {
            this.addModule(module);
        }
    }

    @Override
    public INaviAddressSpace getNative() {
        return this.m_addressSpace;
    }

    public void addListener(IAddressSpaceListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void addModule(Module module) throws CouldntSaveDataException {
        try {
            this.m_addressSpace.getContent().addModule(module.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public boolean close() {
        return this.m_addressSpace.close();
    }

    public Date getCreationDate() {
        return this.m_addressSpace.getConfiguration().getCreationDate();
    }

    public Debugger getDebugger() {
        return this.m_debugger;
    }

    public DebuggerTemplate getDebuggerTemplate() {
        com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate internalTemplate = this.m_addressSpace.getConfiguration().getDebuggerTemplate();
        return internalTemplate == null ? null : ObjectFinders.getObject(internalTemplate, this.m_database.getDebuggerTemplateManager().getDebuggerTemplates());
    }

    public String getDescription() {
        return this.m_addressSpace.getConfiguration().getDescription();
    }

    public Address getImagebase(Module module) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        return new Address(this.m_addressSpace.getContent().getImageBase(module.getNative()).toBigInteger());
    }

    public Date getModificationDate() {
        return this.m_addressSpace.getConfiguration().getModificationDate();
    }

    public List<Module> getModules() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: Address space is not loaded");
        }
        return new ArrayList<Module>(this.m_modules);
    }

    public String getName() {
        return this.m_addressSpace.getConfiguration().getName();
    }

    public Project getProject() {
        return this.m_project;
    }

    public boolean isLoaded() {
        return this.m_addressSpace.isLoaded();
    }

    public void load() throws CouldntLoadDataException {
        if (this.isLoaded()) {
            return;
        }
        try {
            this.m_addressSpace.load();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException | LoadCancelledException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public void removeListener(IAddressSpaceListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void removeModule(Module module) throws CouldntDeleteException, CouldntSaveDataException {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        try {
            this.m_addressSpace.getContent().removeModule(module.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void setDebuggerTemplate(DebuggerTemplate template) throws CouldntSaveDataException {
        try {
            this.m_addressSpace.getConfiguration().setDebuggerTemplate(template == null ? null : template.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "Error: Description argument can not be null");
        try {
            this.m_addressSpace.getConfiguration().setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setImageBase(Module module, Address address) throws CouldntSaveDataException {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        try {
            this.m_addressSpace.getContent().setImageBase(module.getNative(), new CAddress(address.toLong()));
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.m_addressSpace.getConfiguration().setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        StringBuilder moduleString = new StringBuilder();
        if (this.isLoaded()) {
            boolean addComma = false;
            for (Module module : this.getModules()) {
                if (addComma) {
                    moduleString.append(", ");
                }
                addComma = true;
                moduleString.append(module.getName());
            }
        } else {
            moduleString.append(String.format("unloaded, %d modules", this.m_addressSpace.getModuleCount()));
        }
        return String.format("Address space %s [%s]", this.getName(), moduleString);
    }

    private class InternalListener
    implements com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceListener {
        private InternalListener() {
        }

        @Override
        public void closed(INaviAddressSpace addressSpace, CAddressSpaceContent content) {
            content.removeListener(AddressSpace.this.m_internalContentListener);
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.closedAddressSpace(AddressSpace.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean closing(INaviAddressSpace addressSpace) {
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    if (listener.closingAddressSpace(AddressSpace.this)) continue;
                    return false;
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            return true;
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            AddressSpace.this.convertData();
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.loadedAddressSpace(AddressSpace.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public boolean loading(AddressSpaceLoadEvents event, int counter) {
            return true;
        }
    }

    private class InternalContentListener
    implements IAddressSpaceContentListener {
        private InternalContentListener() {
        }

        @Override
        public void addedModule(INaviAddressSpace addressSpace, INaviModule module) {
            Module newModule = AddressSpace.this.addModule(module);
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.addedModule(AddressSpace.this, newModule);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress address) {
            Address newAddress = new Address(address.toBigInteger());
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.changedImageBase(AddressSpace.this, (Module)ObjectFinders.getObject(module, AddressSpace.this.m_modules), newAddress);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedModule(INaviAddressSpace addressSpace, INaviModule module) {
            Module deletedModule = (Module)ObjectFinders.getObject(module, AddressSpace.this.m_modules);
            AddressSpace.this.m_modules.remove(deletedModule);
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.removedModule(AddressSpace.this, deletedModule);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    private class InternalConfigurationListener
    implements IAddressSpaceConfigurationListener {
        private InternalConfigurationListener() {
        }

        @Override
        public void changedDebugger(INaviAddressSpace addressSpace, com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debugger) {
            AddressSpace.this.m_debugger = addressSpace.getConfiguration().getDebugger() == null ? null : new Debugger(addressSpace.getConfiguration().getDebugger());
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.changedDebugger(AddressSpace.this, AddressSpace.this.m_debugger);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDescription(INaviAddressSpace addressSpace, String description) {
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.changedDescription(AddressSpace.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedModificationDate(CAddressSpace addressSpace, Date modificationDate) {
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.changedModificationDate(AddressSpace.this, modificationDate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(INaviAddressSpace addressSpace, String name) {
            for (IAddressSpaceListener listener : AddressSpace.this.m_listeners) {
                try {
                    listener.changedName(AddressSpace.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

