/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.disassembly.Trace;
import com.google.security.zynamics.binnavi.API.disassembly.TracePoint;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.ModuleTraceProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.ProjectTraceProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TraceLogger {
    private final Debugger debugger;
    private final Project project;
    private final Module module;
    private com.google.security.zynamics.binnavi.debug.models.trace.TraceLogger logger;

    public TraceLogger(Debugger debugger, Module module) {
        Preconditions.checkNotNull(debugger, "Error: Debugger argument can not be null");
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        this.debugger = debugger;
        this.module = module;
        this.project = null;
    }

    public TraceLogger(Debugger debugger, Project project) {
        Preconditions.checkNotNull(debugger, "Error: Debugger argument can not be null");
        Preconditions.checkNotNull(project, "Error: Project argument can not be null");
        this.debugger = debugger;
        this.project = project;
        this.module = null;
    }

    private static Set<BreakpointAddress> convertAddresses(List<TracePoint> addresses) {
        HashSet<BreakpointAddress> adds = new HashSet<BreakpointAddress>();
        for (TracePoint address : addresses) {
            if (address.getModule() == null) {
                adds.add(new BreakpointAddress(null, new UnrelocatedAddress(new CAddress(address.getAddress().toLong()))));
                continue;
            }
            adds.add(new BreakpointAddress(address.getModule().getNative(), new UnrelocatedAddress(new CAddress(address.getAddress().toLong()))));
        }
        return adds;
    }

    private com.google.security.zynamics.binnavi.debug.models.trace.TraceLogger createLogger() {
        return new com.google.security.zynamics.binnavi.debug.models.trace.TraceLogger(this.project == null ? new ModuleTraceProvider(this.module.getNative()) : new ProjectTraceProvider(this.project.getNative()), this.debugger.getNative());
    }

    private TraceList createTrace(String name, String description) throws CouldntSaveDataException {
        return this.project == null ? this.module.getNative().getContent().getTraceContainer().createTrace(name, description) : this.project.getNative().getContent().createTrace(name, description);
    }

    private Iterable<Trace> getTraces() {
        return this.project == null ? this.module.getTraces() : this.project.getTraces();
    }

    public Trace start(String name, String description, List<TracePoint> addresses) throws com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException {
        Preconditions.checkArgument(this.debugger.isConnected(), "Error: Debugger must be connected");
        Preconditions.checkArgument(this.logger == null, "Error: Addresses argument can not be null");
        Preconditions.checkNotNull(addresses, "Error: Addresses argument can not be null");
        for (TracePoint address : addresses) {
            Preconditions.checkNotNull(address, "Error: Addresses list contains null-elements");
        }
        try {
            TraceList trace2 = this.createTrace(name, description);
            this.logger = this.createLogger();
            this.logger.start(trace2, TraceLogger.convertAddresses(addresses), 3);
            return ObjectFinders.getObject(trace2, this.getTraces());
        }
        catch (CouldntSaveDataException e2) {
            throw new com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException(e2);
        }
    }

    public void stop() {
        Preconditions.checkNotNull(this.logger, "Error: Logger is already stopped");
        this.logger.stop();
        this.logger = null;
    }

    public String toString() {
        return String.format("TraceLogger [%s : %s]", this.debugger.toString(), this.project == null ? this.module.getName() : this.project.getName());
    }
}

