/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.DebuggerDebugException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TargetInformation {
    private final com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation targetInformation;

    public TargetInformation(com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation targetInformation) {
        Preconditions.checkNotNull(targetInformation, "Error: Target information argument can not be null");
        this.targetInformation = targetInformation;
    }

    public boolean canAttach() {
        return this.targetInformation.getDebuggerOptions().canAttach();
    }

    public boolean canDetach() {
        return this.targetInformation.getDebuggerOptions().canDetach();
    }

    public boolean canHalt() {
        return this.targetInformation.getDebuggerOptions().canHalt();
    }

    public boolean canMapMemory() {
        return this.targetInformation.getDebuggerOptions().canMemmap();
    }

    public boolean canMultithread() {
        return this.targetInformation.getDebuggerOptions().canMultithread();
    }

    public boolean canSoftwareBreakpoint() {
        return this.targetInformation.getDebuggerOptions().canSoftwareBreakpoint();
    }

    public boolean canTerminate() {
        return this.targetInformation.getDebuggerOptions().canTerminate();
    }

    public boolean canTracecount() {
        return this.targetInformation.getDebuggerOptions().canTraceCount();
    }

    public boolean canValidateMemory() {
        return this.targetInformation.getDebuggerOptions().canValidMemory();
    }

    public int getAddressSize() {
        return this.targetInformation.getAddressSize();
    }

    public String toString() {
        return "Target Information Object";
    }

    public Collection<DebuggerDebugException> getExceptionSettings() {
        List<DebuggerDebugException> exceptions2 = Collections.emptyList();
        for (DebuggerException exception : this.targetInformation.getDebuggerOptions().getExceptions()) {
            exceptions2.add(new DebuggerDebugException(exception));
        }
        return exceptions2;
    }
}

