/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.IMemoryListener;
import com.google.security.zynamics.binnavi.API.debug.MissingDataException;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import java.util.ArrayList;
import java.util.List;

public final class Memory {
    private final com.google.security.zynamics.zylib.general.memmanager.Memory m_memory;
    private final List<IMemoryListener> m_listeners = new ArrayList<IMemoryListener>();
    private final InternalMemoryListener m_listener = new InternalMemoryListener();

    public Memory(com.google.security.zynamics.zylib.general.memmanager.Memory memory) {
        this.m_memory = memory;
        memory.addMemoryListener(this.m_listener);
    }

    public void addListener(IMemoryListener listener) {
        this.m_listeners.add(listener);
    }

    public byte[] getData(long start, int length) throws MissingDataException {
        Preconditions.checkArgument(start >= 0L, "Error: Address can't be less than 0");
        Preconditions.checkArgument(length > 0, "Error: Length must be positive");
        try {
            return this.m_memory.getData(start, length);
        }
        catch (IllegalArgumentException exception) {
            throw new MissingDataException(String.format("Memory data between %d and %d is not available", start, start + (long)length - 1L));
        }
    }

    public boolean hasData(long start, int length) {
        return this.m_memory.hasData(start, length);
    }

    public void removeListener(IMemoryListener listener) {
        this.m_listeners.remove(listener);
    }

    public String toString() {
        return String.format("Simulated Memory (Size: %d Bytes)", this.m_memory.getMemorySize());
    }

    private class InternalMemoryListener
    implements com.google.security.zynamics.zylib.general.memmanager.IMemoryListener {
        private InternalMemoryListener() {
        }

        @Override
        public void memoryChanged(long address, int size) {
            for (IMemoryListener listener : Memory.this.m_listeners) {
                try {
                    listener.changedMemory(Memory.this, address, size);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void memoryCleared() {
            for (IMemoryListener listener : Memory.this.m_listeners) {
                try {
                    listener.clearedMemory(Memory.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

