/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.BookmarkManager;
import com.google.security.zynamics.binnavi.API.debug.BreakpointManager;
import com.google.security.zynamics.binnavi.API.debug.DebugException;
import com.google.security.zynamics.binnavi.API.debug.DebuggerAttachReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerAuthenticationFailedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerBreakpointConditionSetReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerBreakpointHitReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerBreakpointSetReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerCancelTargetSelectionReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerDebugException;
import com.google.security.zynamics.binnavi.API.debug.DebuggerDebuggerClosedUnexpectedlyReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerDetachReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerEchoBreakpointHitReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerEchoBreakpointSetReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerEchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerExceptionOccurredReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerHaltReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerMemoryMapReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerModuleLoadedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerModuleUnloadedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerProcessClosedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerProcessStartReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerReadMemoryReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerRegistersReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerRequestTargetReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerResumeReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerResumeThreadReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerSetExceptionSettingsReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerSetRegisterReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerSingleStepReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerSuspendThreadReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerTargetInformationReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerTerminateReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerThreadClosedReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerThreadCreatedReply;
import com.google.security.zynamics.binnavi.API.debug.IDebuggerListener;
import com.google.security.zynamics.binnavi.API.debug.Process;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AttachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AuthenticationFailedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointConditionSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.CancelTargetSelectionReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerClosedUnexpectedlyReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DetachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ExceptionOccurredReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.HaltReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListFilesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListProcessesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.MemoryMapReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleLoadedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleUnloadedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessStartReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.QueryDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ReadMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RegistersReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RequestTargetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeThreadReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SearchReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SelectFileReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SelectProcessReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetExceptionSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetRegisterReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SingleStepReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SuspendThreadReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TargetInformationReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TerminateReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadCreatedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ValidateMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.WriteMemoryReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerEventSettings;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterDescription;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Debugger
implements ApiObject<IDebugger> {
    private final IDebugger m_debugger;
    private final Process m_process;
    private final BookmarkManager m_bookmarkManager;
    private final BreakpointManager m_breakpointManager;
    private final IDebugEventListener m_listener = new InternalDebugEventListener();
    private final ListenerProvider<IDebuggerListener> m_listeners = new ListenerProvider();

    public Debugger(IDebugger debugger) {
        this.m_debugger = debugger;
        this.m_process = new Process(this.m_debugger.getProcessManager());
        this.m_bookmarkManager = new BookmarkManager(this.m_debugger.getBookmarkManager());
        this.m_breakpointManager = new BreakpointManager(this.m_debugger.getBreakpointManager());
        this.m_debugger.addListener(this.m_listener);
    }

    @Override
    public IDebugger getNative() {
        return this.m_debugger;
    }

    public void addListener(IDebuggerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void cancelTargetSelection() throws DebugException {
        try {
            this.m_debugger.cancelTargetSelection();
            this.m_debugger.setTerminated();
        }
        catch (DebugExceptionWrapper exception) {
            throw new DebugException(exception);
        }
    }

    public void connect() throws DebugException {
        try {
            this.m_debugger.connect();
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public void detach() throws DebugException {
        try {
            this.m_debugger.detach();
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public BookmarkManager getBookmarkManager() {
        return this.m_bookmarkManager;
    }

    public BreakpointManager getBreakpointManager() {
        return this.m_breakpointManager;
    }

    public Process getProcess() {
        return this.m_process;
    }

    public boolean isConnected() {
        return this.m_debugger.isConnected();
    }

    public void readMemory(Address address, int size) throws DebugException {
        try {
            this.m_debugger.readMemory(new CAddress(address.toLong()), size);
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public void readRegisters() throws DebugException {
        try {
            this.m_debugger.readRegisters();
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public void removeListener(IDebuggerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void requestFileSystem() throws DebugException {
        try {
            this.m_debugger.requestFileSystem();
        }
        catch (DebugExceptionWrapper exception) {
            throw new DebugException(exception);
        }
    }

    public void requestFileSystem(String path) throws DebugException {
        try {
            this.m_debugger.requestFileSystem(path);
        }
        catch (DebugExceptionWrapper exception) {
            throw new DebugException(exception);
        }
    }

    public void resume() throws DebugException {
        try {
            this.m_debugger.resume();
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public void selectFile(String file) throws DebugException {
        try {
            this.m_debugger.selectFile(file);
        }
        catch (DebugExceptionWrapper exception) {
            throw new DebugException(exception);
        }
    }

    public void setExceptionSettings(Collection<DebuggerDebugException> exceptions2) throws DebugException {
        List<DebuggerException> nativeExceptions = Collections.emptyList();
        for (DebuggerDebugException exception : exceptions2) {
            nativeExceptions.add(exception.getNative());
        }
        try {
            this.m_debugger.setExceptionSettings(nativeExceptions);
        }
        catch (DebugExceptionWrapper exception) {
            throw new DebugException(exception);
        }
    }

    public void singleStep() throws DebugException {
        try {
            this.m_debugger.singleStep();
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public void terminate() throws DebugException {
        try {
            this.m_debugger.terminate();
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public Address toFilebase(Module module, Address address) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        return new Address(this.m_debugger.memoryToFile(module.getNative(), new RelocatedAddress(new CAddress(address.toLong()))).getAddress().toBigInteger());
    }

    public Address toImagebase(Module module, Address address) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        return new Address(this.m_debugger.fileToMemory(module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong()))).getAddress().toBigInteger());
    }

    public String toString() {
        return String.format("Debugger '%s'", this.m_debugger.getPrintableString());
    }

    public void writeMemory(Address address, byte[] data) throws DebugException {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        Preconditions.checkNotNull(data, "Error: Data argument can not be null");
        try {
            this.m_debugger.writeMemory(new CAddress(address.toLong()), data);
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    public void writeRegister(long tid, String register2, long value) throws DebugException {
        Preconditions.checkNotNull(register2, "Error: Register argument can not be null");
        Preconditions.checkNotNull(this.m_debugger.getProcessManager().getTargetInformation(), "Error: Target information string has not yet been received");
        List<RegisterDescription> registers = this.m_debugger.getProcessManager().getTargetInformation().getRegisters();
        int index = 0;
        for (RegisterDescription description : registers) {
            if (description.getName().equalsIgnoreCase(register2)) {
                if (description.isEditable()) break;
                throw new IllegalArgumentException("Error: Selected register can not be edited");
            }
            ++index;
        }
        if (index == registers.size()) {
            throw new IllegalArgumentException("Error: Unknown register name");
        }
        try {
            this.m_debugger.setRegister(tid, index, BigInteger.valueOf(value));
        }
        catch (DebugExceptionWrapper e2) {
            throw new DebugException(e2);
        }
    }

    private class InternalDebugEventListener
    implements IDebugEventListener {
        private InternalDebugEventListener() {
        }

        @Override
        public void debugException(DebugExceptionWrapper debugException) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.debugException(debugException);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void debuggerClosed(int errorCode) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.debuggerClosed(errorCode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(AttachReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.debuggerAttach(new DebuggerAttachReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(AuthenticationFailedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.authenticationFailed(new DebuggerAuthenticationFailedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(BreakpointConditionSetReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.breakpointConditionSet(new DebuggerBreakpointConditionSetReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(BreakpointHitReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.breakpointHit(new DebuggerBreakpointHitReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(BreakpointSetReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.breakpointSet(new DebuggerBreakpointSetReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(BreakpointsRemovedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.breakpointsRemoved(new DebuggerBreakpointsRemovedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(CancelTargetSelectionReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.cancelTargetSelection(new DebuggerCancelTargetSelectionReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(DebuggerClosedUnexpectedlyReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.debuggerClosedUnexpectedly(new DebuggerDebuggerClosedUnexpectedlyReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(DetachReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.debuggerDetached(new DebuggerDetachReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(EchoBreakpointHitReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.echoBreakpointHit(new DebuggerEchoBreakpointHitReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(EchoBreakpointSetReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.echoBreakpointSet(new DebuggerEchoBreakpointSetReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(EchoBreakpointsRemovedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.echoBreakpointsRemoved(new DebuggerEchoBreakpointsRemovedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ExceptionOccurredReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.exceptionOccurred(new DebuggerExceptionOccurredReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(HaltReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.debuggerHalt(new DebuggerHaltReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ListFilesReply reply) {
        }

        @Override
        public void receivedReply(ListProcessesReply reply) {
        }

        @Override
        public void receivedReply(MemoryMapReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.memoryMap(new DebuggerMemoryMapReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ModuleLoadedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.moduleLoaded(new DebuggerModuleLoadedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ModuleUnloadedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.moduleUnloaded(new DebuggerModuleUnloadedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ProcessClosedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.processClosed(new DebuggerProcessClosedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ProcessStartReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.processStart(new DebuggerProcessStartReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(QueryDebuggerEventSettingsReply reply) {
            try {
                Debugger.this.m_debugger.setDebuggerEventSettings(new DebuggerEventSettings(false, false));
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }

        @Override
        public void receivedReply(ReadMemoryReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.readMemory(new DebuggerReadMemoryReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(RegistersReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.registersReply(new DebuggerRegistersReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(RequestTargetReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.requestTarget(new DebuggerRequestTargetReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ResumeReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.processResumed(new DebuggerResumeReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ResumeThreadReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.threadResumed(new DebuggerResumeThreadReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(SearchReply reply) {
        }

        @Override
        public void receivedReply(SelectFileReply reply) {
        }

        @Override
        public void receivedReply(SelectProcessReply reply) {
        }

        @Override
        public void receivedReply(SetDebuggerEventSettingsReply reply) {
        }

        @Override
        public void receivedReply(SetExceptionSettingsReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.setExceptionSettings(new DebuggerSetExceptionSettingsReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(SetRegisterReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.setRegister(new DebuggerSetRegisterReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(SingleStepReply reply) {
            Preconditions.checkNotNull(reply, "Error: reply argument can not be null");
            Preconditions.checkNotNull(reply.getAddress(), "Error: reply.getAddress() argument can not be null");
            Preconditions.checkNotNull(reply.getAddress().getAddress(), "Error: reply.getAddress().getAddress() argument can not be null");
            Preconditions.checkNotNull(reply.getRegisterValues(), "Error: reply.getRegisterValues() argument can not be null");
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.singleStep(new DebuggerSingleStepReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(StepBreakpointHitReply reply) {
        }

        @Override
        public void receivedReply(StepBreakpointSetReply reply) {
        }

        @Override
        public void receivedReply(StepBreakpointsRemovedReply reply) {
        }

        @Override
        public void receivedReply(SuspendThreadReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.threadSuspended(new DebuggerSuspendThreadReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(TargetInformationReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.targetInformation(new DebuggerTargetInformationReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(TerminateReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.terminated(new DebuggerTerminateReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ThreadClosedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.threadClosed(new DebuggerThreadClosedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ThreadCreatedReply reply) {
            for (IDebuggerListener listener : Debugger.this.m_listeners) {
                try {
                    listener.threadCreated(new DebuggerThreadCreatedReply(reply));
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void receivedReply(ValidateMemoryReply reply) {
        }

        @Override
        public void receivedReply(WriteMemoryReply reply) {
        }
    }
}

