/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.BreakpointManager;
import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CodeNode;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionNode;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.ArrayList;
import java.util.List;

public final class BreakpointHelpers {
    private BreakpointHelpers() {
    }

    private static List<Address> getBreakpoints(Debugger debugger, CodeNode node, BreakpointType type) {
        Preconditions.checkNotNull(debugger, "Error: Debugger argument can not be null");
        Preconditions.checkNotNull(node, "Error: Node argument can not be null");
        BreakpointManager manager = debugger.getBreakpointManager();
        ArrayList<Address> breakpoints = new ArrayList<Address>();
        for (Instruction instruction : node.getInstructions()) {
            BreakpointAddress address = new BreakpointAddress(instruction.getNative().getModule(), new UnrelocatedAddress(new CAddress(instruction.getAddress().toLong())));
            if (!manager.getNative().hasBreakpoint(type, address)) continue;
            breakpoints.add(new Address(address.getAddress().getAddress().toBigInteger()));
        }
        return breakpoints;
    }

    private static List<Address> getBreakpoints(Debugger debugger, View view, BreakpointType type) {
        Preconditions.checkNotNull(debugger, "Error: Debugger argument can not be null");
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        BreakpointManager manager = debugger.getBreakpointManager();
        ArrayList<Address> breakpoints = new ArrayList<Address>();
        for (ViewNode node : view.getGraph().getNodes()) {
            if (node instanceof CodeNode) {
                breakpoints.addAll(BreakpointHelpers.getBreakpoints(debugger, (CodeNode)node, type));
                continue;
            }
            if (!(node instanceof FunctionNode)) continue;
            FunctionNode fnode = (FunctionNode)node;
            BreakpointAddress address = new BreakpointAddress(fnode.getFunction().getNative().getModule(), new UnrelocatedAddress(fnode.getFunction().getNative().getAddress()));
            if (!manager.getNative().hasBreakpoint(type, address)) continue;
            breakpoints.add(new Address(address.getAddress().getAddress().toBigInteger()));
        }
        return breakpoints;
    }

    public static List<Address> getBreakpoints(Debugger debugger, CodeNode node) {
        return BreakpointHelpers.getBreakpoints(debugger, node, BreakpointType.REGULAR);
    }

    public static List<Address> getBreakpoints(Debugger debugger, View view) {
        return BreakpointHelpers.getBreakpoints(debugger, view, BreakpointType.REGULAR);
    }

    public static List<Address> getEchoBreakpoints(Debugger debugger, CodeNode node) {
        return BreakpointHelpers.getBreakpoints(debugger, node, BreakpointType.ECHO);
    }

    public static List<Address> getEchoBreakpoints(Debugger debugger, View view) {
        return BreakpointHelpers.getBreakpoints(debugger, view, BreakpointType.ECHO);
    }
}

