/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.security.zynamics.binnavi.API.debug.IBookmarkListener;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.CBookmark;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class Bookmark
implements ApiObject<CBookmark> {
    private final CBookmark m_bookmark;
    private final InternalBookmarkListener m_internalBookmarkListener = new InternalBookmarkListener();
    private final ListenerProvider<IBookmarkListener> m_listeners = new ListenerProvider();

    public Bookmark(CBookmark bookmark) {
        this.m_bookmark = bookmark;
        this.m_bookmark.addListener(this.m_internalBookmarkListener);
    }

    @Override
    public CBookmark getNative() {
        return this.m_bookmark;
    }

    public void addListener(IBookmarkListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Address getAddress() {
        return new Address(this.m_bookmark.getAddress().toBigInteger());
    }

    public String getDescription() {
        return this.m_bookmark.getDescription();
    }

    public void removeListener(IBookmarkListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDescription(String description) {
        this.m_bookmark.setDescription(description);
    }

    public String toString() {
        return String.format("Bookmark %s/'%s'", this.getAddress().toHexString(), this.getDescription());
    }

    private class InternalBookmarkListener
    implements com.google.security.zynamics.binnavi.models.Bookmarks.memory.IBookmarkListener {
        private InternalBookmarkListener() {
        }

        @Override
        public void changedDescription(CBookmark bookmark, String description) {
            for (IBookmarkListener listener : Bookmark.this.m_listeners) {
                listener.changedDescription(Bookmark.this, description);
            }
        }
    }
}

