/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value) {
        if (key == null) {
            String string2 = String.valueOf(String.valueOf(value));
            throw new NullPointerException(new StringBuilder(24 + string2.length()).append("null key in entry: null=").append(string2).toString());
        }
        if (value == null) {
            String string3 = String.valueOf(String.valueOf(key));
            throw new NullPointerException(new StringBuilder(26 + string3.length()).append("null value in entry: ").append(string3).append("=null").toString());
        }
    }

    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            String string2 = String.valueOf(String.valueOf(name));
            int n2 = value;
            throw new IllegalArgumentException(new StringBuilder(40 + string2.length()).append(string2).append(" cannot be negative but was: ").append(n2).toString());
        }
        return value;
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

