/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.lowlevel;

import java.util.List;
import javalx.numeric.Interval;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;
import rreil.lang.lowlevel.PrimitiveInstruction;
import rreil.lang.lowlevel.TranslationHelpers;

public class LowLevelRReilFactory {
    private static LowLevelRReilFactory INSTANCE = new LowLevelRReilFactory();
    public static final String $Add = "add";
    public static final String $And = "and";
    public static final String $Brc = "if";
    public static final String $Call = "call";
    public static final String $Return = "return";
    public static final String $Cmpeq = "cmpeq";
    public static final String $Cmpneq = "cmpneq";
    public static final String $Cmples = "cmples";
    public static final String $Cmpleu = "cmpleu";
    public static final String $Cmplts = "cmplts";
    public static final String $Cmpltu = "cmpltu";
    public static final String $Divu = "divu";
    public static final String $Divs = "divs";
    public static final String $Load = "load";
    public static final String $Mod = "mod";
    public static final String $Mov = "mov";
    public static final String $Assert = "assert";
    public static final String $SignExtend = "sign-extend";
    public static final String $Convert = "convert";
    public static final String $Mul = "mul";
    public static final String $Nop = "nop";
    public static final String $Or = "or";
    public static final String $Shl = "shl";
    public static final String $Shru = "shru";
    public static final String $Shrs = "shrs";
    public static final String $Store = "store";
    public static final String $Sub = "sub";
    public static final String $Xor = "xor";
    public static final String $PrimOp = "primop#";
    public static final String $Native = "native#";

    private LowLevelRReilFactory() {
    }

    public static LowLevelRReilFactory getInstance() {
        return INSTANCE;
    }

    private static LowLevelRReil make(RReilAddr offset, String mnemonic, LowLevelRReilOpnd ... operands) {
        return new LowLevelRReil(offset, mnemonic, operands);
    }

    private static LowLevelRReilOpnd makeOperand(OperandSize size, OperandTree.Type ty, Object value) {
        return LowLevelRReilFactory.makeOperand(size.getBits(), ty, value);
    }

    private static LowLevelRReilOpnd makeOperand(Number size, OperandTree.Type ty, Object value) {
        OperandTree.NodeBuilder root = new OperandTree.NodeBuilder().type(OperandTree.Type.Size).data(size);
        OperandTree.Node child = new OperandTree.NodeBuilder().type(ty).data(value).build();
        return new LowLevelRReilOpnd(root.link(child).build());
    }

    public LowLevelRReilOpnd variable(OperandSize size, String name) {
        return LowLevelRReilFactory.makeOperand(size, OperandTree.Type.Sym, (Object)name);
    }

    public LowLevelRReilOpnd variable(Number size, String name) {
        return LowLevelRReilFactory.makeOperand(size, OperandTree.Type.Sym, (Object)name);
    }

    public LowLevelRReilOpnd flag(String name) {
        return this.variable(1, name);
    }

    public LowLevelRReilOpnd immediate(Number size, Number value) {
        return LowLevelRReilFactory.makeOperand(size, OperandTree.Type.Immi, (Object)value);
    }

    public LowLevelRReilOpnd immediate(OperandSize size, Number value) {
        return LowLevelRReilFactory.makeOperand(size, OperandTree.Type.Immi, (Object)value);
    }

    public LowLevelRReilOpnd range(Number size, Interval range) {
        return LowLevelRReilFactory.makeOperand(size, OperandTree.Type.Immr, (Object)range);
    }

    public LowLevelRReilOpnd range(OperandSize size, Interval range) {
        return LowLevelRReilFactory.makeOperand(size, OperandTree.Type.Immr, (Object)range);
    }

    public LowLevelRReilOpnd immediateSizeFixup(int size, LowLevelRReilOpnd a) {
        if (a.child().getType() == OperandTree.Type.Immi && size != a.size()) {
            return a.withSize(size);
        }
        return a;
    }

    private static void assertEqualSize(LowLevelRReilOpnd a, LowLevelRReilOpnd b) {
        if (a.size() != b.size()) {
            throw new IllegalArgumentException("Error: Incompatible operand sizes");
        }
    }

    private static void assertEqualSize(LowLevelRReilOpnd lhs, LowLevelRReilOpnd a, LowLevelRReilOpnd b) {
        if (lhs.size() != a.size() || lhs.size() != b.size()) {
            throw new IllegalArgumentException("Error: Incompatible operand sizes");
        }
    }

    private static void assertEqualSize(LowLevelRReilOpnd a, OperandSize sz) {
        if (a.size() != sz.getBits()) {
            throw new IllegalArgumentException("Error: Incompatible operand sizes");
        }
    }

    public LowLevelRReil UNDEF(RReilAddr offset, LowLevelRReilOpnd dst) {
        return this.MOV(offset, dst, this.range(dst.size(), Interval.unsignedTop(dst.size())));
    }

    public LowLevelRReil ADD(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Add, dst, src1, src2);
    }

    public LowLevelRReil DIVU(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Divu, dst, src1, src2);
    }

    public LowLevelRReil DIVS(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Divs, dst, src1, src2);
    }

    public LowLevelRReil MUL(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Mul, dst, src1, src2);
    }

    public LowLevelRReil SUB(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Sub, dst, src1, src2);
    }

    public LowLevelRReil LOAD(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1) {
        return LowLevelRReilFactory.make(offset, $Load, dst, src1);
    }

    public LowLevelRReil STORE(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1) {
        return LowLevelRReilFactory.make(offset, $Store, dst, src1);
    }

    public LowLevelRReil CMPEQ(RReilAddr offset, LowLevelRReilOpnd flag, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(src1, src2);
        LowLevelRReilFactory.assertEqualSize(flag, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Cmpeq, flag, src1, src2);
    }

    public LowLevelRReil CMPNEQ(RReilAddr offset, LowLevelRReilOpnd flag, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(src1, src2);
        LowLevelRReilFactory.assertEqualSize(flag, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Cmpneq, flag, src1, src2);
    }

    public LowLevelRReil CMPLES(RReilAddr offset, LowLevelRReilOpnd flag, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(src1, src2);
        LowLevelRReilFactory.assertEqualSize(flag, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Cmples, flag, src1, src2);
    }

    public LowLevelRReil CMPLEU(RReilAddr offset, LowLevelRReilOpnd flag, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(src1, src2);
        LowLevelRReilFactory.assertEqualSize(flag, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Cmpleu, flag, src1, src2);
    }

    public LowLevelRReil CMPLTS(RReilAddr offset, LowLevelRReilOpnd flag, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(src1, src2);
        LowLevelRReilFactory.assertEqualSize(flag, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Cmplts, flag, src1, src2);
    }

    public LowLevelRReil CMPLTU(RReilAddr offset, LowLevelRReilOpnd flag, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(src1, src2);
        LowLevelRReilFactory.assertEqualSize(flag, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Cmpltu, flag, src1, src2);
    }

    public LowLevelRReil AND(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $And, dst, src1, src2);
    }

    public LowLevelRReil XOR(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Xor, dst, src1, src2);
    }

    public LowLevelRReil OR(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Or, dst, src1, src2);
    }

    public LowLevelRReil SHRU(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Shru, dst, src1, src2);
    }

    public LowLevelRReil SHRS(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Shrs, dst, src1, src2);
    }

    public LowLevelRReil SHL(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Shl, dst, src1, src2);
    }

    public LowLevelRReil MOD(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2) {
        LowLevelRReilFactory.assertEqualSize(dst, src1, src2);
        return LowLevelRReilFactory.make(offset, $Mod, dst, src1, src2);
    }

    public LowLevelRReil MOV(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src) {
        LowLevelRReilFactory.assertEqualSize(dst, src);
        return LowLevelRReilFactory.make(offset, $Mov, dst, src);
    }

    public LowLevelRReil ASSERT(RReilAddr offset, LowLevelRReilOpnd lhs, LowLevelRReilOpnd rhs) {
        LowLevelRReilFactory.assertEqualSize(lhs, rhs);
        return LowLevelRReilFactory.make(offset, $Assert, lhs, rhs);
    }

    public LowLevelRReil SIGNEXTEND(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src) {
        return LowLevelRReilFactory.make(offset, $SignExtend, dst, src);
    }

    public LowLevelRReil CONVERT(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src) {
        return LowLevelRReilFactory.make(offset, $Convert, dst, src);
    }

    public LowLevelRReil NOP(RReilAddr offset) {
        return LowLevelRReilFactory.make(offset, $Nop, new LowLevelRReilOpnd[0]);
    }

    public LowLevelRReil IFGOTO(RReilAddr offset, LowLevelRReilOpnd cond, LowLevelRReilOpnd dst) {
        LowLevelRReilFactory.assertEqualSize(cond, OperandSize.BIT);
        return LowLevelRReilFactory.make(offset, $Brc, cond, dst);
    }

    public LowLevelRReil CALL(RReilAddr offset, LowLevelRReilOpnd dst) {
        return LowLevelRReilFactory.make(offset, $Call, this.immediate(OperandSize.BIT, (Number)1), dst);
    }

    public LowLevelRReil RETURN(RReilAddr offset, LowLevelRReilOpnd dst) {
        return LowLevelRReilFactory.make(offset, $Return, this.immediate(OperandSize.BIT, (Number)1), dst);
    }

    public LowLevelRReil PRIMOP(RReilAddr offset, String primop, List<LowLevelRReilOpnd> outArgs, List<LowLevelRReilOpnd> inArgs) {
        return new PrimitiveInstruction(offset, $PrimOp + primop, inArgs, outArgs);
    }

    public LowLevelRReil NATIVE(RReilAddr offset, Instruction nativeInsn) {
        LowLevelRReilOpnd[] rreilOperands = new LowLevelRReilOpnd[nativeInsn.operands().size()];
        for (int i = 0; i < nativeInsn.operands().size(); ++i) {
            rreilOperands[i] = new LowLevelRReilOpnd(nativeInsn.operands().get(i).getRoot());
        }
        return LowLevelRReilFactory.make(offset, $Native + nativeInsn.mnemonic(), rreilOperands);
    }

    public LowLevelRReil NOT(RReilAddr offset, LowLevelRReilOpnd dst, LowLevelRReilOpnd src) {
        LowLevelRReilFactory.assertEqualSize(dst, src);
        return this.XOR(offset, dst, src, TranslationHelpers.getMaxImmediate(src.size()));
    }

    public LowLevelRReil GOTONATIVE(RReilAddr offset, LowLevelRReilOpnd dst) {
        return this.IFGOTO(offset, this.immediate(OperandSize.BIT, (Number)1), dst);
    }

    public LowLevelRReil GOTORREIL(RReilAddr address, long base, long offset) {
        return this.IFGOTORREIL(address, this.immediate(1, (Number)1), base, offset);
    }

    public LowLevelRReil IFGOTORREIL(RReilAddr address, LowLevelRReilOpnd cond, long base, long offset) {
        int size = 32;
        OperandTree.NodeBuilder subAddressBuilder = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data(".");
        OperandTree.Node rreilBase = new OperandTree.NodeBuilder().type(OperandTree.Type.Immi).data(base).build();
        OperandTree.Node rreilOffset = new OperandTree.NodeBuilder().type(OperandTree.Type.Immi).data(offset).build();
        OperandTree.NodeBuilder rootBuilder = new OperandTree.NodeBuilder().type(OperandTree.Type.Size).data(size);
        OperandTree.Node subAddress = subAddressBuilder.link(rreilBase).link(rreilOffset).build();
        return this.IFGOTO(address, cond, new LowLevelRReilOpnd(rootBuilder.link(subAddress).build()));
    }
}

