/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import java.util.HashMap;
import java.util.Map;
import rreil.lang.ComparisonOp;
import rreil.lang.Reconstructable;
import rreil.lang.SignednessHint;

public enum AssertionOp implements Reconstructable
{
    AffineEquality("*+="),
    Equal("="),
    NotEqual("!="),
    UnsignedLessThanOrEqual("<=u"),
    SignedLessThanOrEqual("<="),
    UnsignedLessThan("<u"),
    SignedLessThan("<");

    private final String opString;
    private static final Map<String, AssertionOp> mappings;

    private AssertionOp(String opString) {
        this.opString = opString;
    }

    public static AssertionOp from(String string) {
        return mappings.get(string);
    }

    public ComparisonOp toComparison() {
        switch (this) {
            case Equal: {
                return ComparisonOp.Cmpeq;
            }
            case AffineEquality: {
                return ComparisonOp.Cmpeq;
            }
            case NotEqual: {
                return ComparisonOp.Cmpneq;
            }
            case SignedLessThan: {
                return ComparisonOp.Cmplts;
            }
            case SignedLessThanOrEqual: {
                return ComparisonOp.Cmples;
            }
            case UnsignedLessThan: {
                return ComparisonOp.Cmpltu;
            }
            case UnsignedLessThanOrEqual: {
                return ComparisonOp.Cmpleu;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.opString;
    }

    public SignednessHint signedness() {
        switch (this) {
            case SignedLessThan: 
            case SignedLessThanOrEqual: {
                return SignednessHint.ForceSigned;
            }
            case UnsignedLessThan: 
            case UnsignedLessThanOrEqual: {
                return SignednessHint.ForceUnsigned;
            }
        }
        return SignednessHint.DontCare;
    }

    @Override
    public String reconstructCode() {
        return "AssertionOp." + super.toString();
    }

    static {
        mappings = new HashMap<String, AssertionOp>();
        for (AssertionOp operator : AssertionOp.values()) {
            mappings.put(operator.toString(), operator);
        }
    }
}

