/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter.avr.chipstate;

import java.io.PrintWriter;
import java.io.StringWriter;
import javalx.numeric.BigInt;
import rreil.disassembler.translators.avr8.implementations.AvrImplementation;
import rreil.interpreter.InterpCtx;
import rreil.interpreter.avr.chipstate.AvrChipStateDelta;
import rreil.tester.gdb.responses.GdbRegistersResponse;

public class AvrChipState {
    private final byte[] dataSpace;

    public byte[] getGeneralPurposeRegisters() {
        byte[] gPRegisters = new byte[AvrImplementation.$ATMEGA32L.getNumRegisters()];
        int gPOffset = AvrImplementation.$ATMEGA32L.getRegistersOffset();
        for (int i = 0; i < gPRegisters.length; ++i) {
            gPRegisters[i] = this.dataSpace[gPOffset + i];
        }
        return gPRegisters;
    }

    public int getSreg() {
        return this.dataSpace[AvrImplementation.$ATMEGA32L.getSregAddress()] & 0xFF;
    }

    public void setSreg(int sreg) {
        this.dataSpace[AvrImplementation.$ATMEGA32L.getSregAddress()] = (byte)sreg;
    }

    public int getSp() {
        return (this.dataSpace[AvrImplementation.$ATMEGA32L.getSpAddress()[0]] & 0xFF) << 8 + (this.dataSpace[AvrImplementation.$ATMEGA32L.getSpAddress()[1]] & 0xFF);
    }

    public void setSp(int sp) {
        this.dataSpace[AvrImplementation.$ATMEGA32L.getSpAddress()[0]] = (byte)(sp >> 8);
        this.dataSpace[AvrImplementation.$ATMEGA32L.getSpAddress()[1]] = (byte)sp;
    }

    public AvrChipStateDelta changed(AvrChipState chipState) {
        boolean[] dataSpaceChanged = new boolean[this.dataSpace.length];
        for (int i = 0; i < dataSpaceChanged.length; ++i) {
            dataSpaceChanged[i] = this.dataSpace[i] != chipState.dataSpace[i];
        }
        return new AvrChipStateDelta(dataSpaceChanged);
    }

    public void toAvrInterpCtx(InterpCtx avrInterpCtx) {
        int i;
        int numGpRegisters = AvrImplementation.$ATMEGA32L.getNumRegisters();
        int gpOffset = AvrImplementation.$ATMEGA32L.getRegistersOffset();
        for (i = 0; i < numGpRegisters; ++i) {
            avrInterpCtx.set("r" + i, BigInt.of(this.dataSpace[gpOffset + i]));
        }
        for (i = 0; i < this.dataSpace.length; ++i) {
            avrInterpCtx.store(8, i, BigInt.of(this.dataSpace[i]));
        }
    }

    public AvrChipState(byte[] dataSpace) {
        this.dataSpace = dataSpace;
    }

    public AvrChipState() {
        this.dataSpace = new byte[AvrImplementation.$ATMEGA32L.getDataSpaceSize()];
    }

    public static AvrChipState fromGdbRegistersResponse(GdbRegistersResponse response) {
        AvrChipState state = new AvrChipState();
        int gpOffset = AvrImplementation.$ATMEGA32L.getRegistersOffset();
        int[] registers = response.getGeneralPurposeRegisters();
        for (int i = 0; i < registers.length; ++i) {
            state.dataSpace[gpOffset + i] = (byte)registers[i];
        }
        state.setSreg(response.getSreg());
        state.setSp(response.getSp());
        return state;
    }

    public static AvrChipState fromGdbMemoryDump(byte[] bytes, int offset, int size) {
        AvrChipState state = new AvrChipState();
        for (int i = 0; i < size; ++i) {
            state.dataSpace[i + offset] = bytes[i];
        }
        return state;
    }

    public static AvrChipState fromAvrInterpCtx(InterpCtx avrInterpCtx) {
        AvrChipState state = new AvrChipState();
        for (int i = 0; i < state.dataSpace.length; ++i) {
            state.dataSpace[i] = avrInterpCtx.load(8, i).bigIntegerValue().byteValue();
        }
        int gpOffset = AvrImplementation.$ATMEGA32L.getRegistersOffset();
        int numGpRegisters = AvrImplementation.$ATMEGA32L.getNumRegisters();
        for (int i = 0; i < numGpRegisters; ++i) {
            state.dataSpace[gpOffset + i] = (byte)avrInterpCtx.get("r" + i).intValue();
        }
        return state;
    }

    public String toString() {
        StringWriter sW = new StringWriter();
        PrintWriter pW = new PrintWriter(sW);
        pW.println("AvrChipState {");
        pW.append(this.getRegistersString());
        pW.println("\t-----------");
        pW.append(this.getIOString());
        pW.println("}");
        return sW.toString();
    }

    private String getPartString(String format, int offset, int size) {
        StringWriter sW = new StringWriter();
        PrintWriter pW = new PrintWriter(sW);
        pW.println("{");
        for (int i = 0; i < size; ++i) {
            pW.printf(format, i, this.dataSpace[offset + i]);
        }
        pW.println("}");
        return sW.toString();
    }

    public String getRegistersString() {
        int registersOffset = AvrImplementation.$ATMEGA32L.getRegistersOffset();
        return this.getPartString("\tr%d\t=\t0x%02x\n", registersOffset, AvrImplementation.$ATMEGA32L.getNumRegisters());
    }

    public String getIOString() {
        int ioOffset = AvrImplementation.$ATMEGA32L.getIORegistersOffset();
        return this.getPartString("\tio[%02d]\t=\t0x%02x\n", ioOffset, AvrImplementation.$ATMEGA32L.getNumIORegisters());
    }

    public String getSramString() {
        int sramOffset = AvrImplementation.$ATMEGA32L.getSRamOffset();
        return this.getPartString("\tsram[%05d]\t=\t0x%02x\n", sramOffset, AvrImplementation.$ATMEGA32L.getSRamSize());
    }

    public String getJavaArrayString() {
        StringWriter sW = new StringWriter();
        PrintWriter pW = new PrintWriter(sW);
        pW.printf("{", new Object[0]);
        for (int i = 0; i < this.dataSpace.length; ++i) {
            pW.printf(" (byte)0x%02x", this.dataSpace[i]);
            if (i + 1 >= this.dataSpace.length) continue;
            pW.printf(",", new Object[0]);
        }
        pW.printf(" }", new Object[0]);
        return sW.toString();
    }

    public String diff(AvrChipState other, AvrChipStateDelta changes) {
        int i;
        StringWriter sW = new StringWriter();
        PrintWriter pW = new PrintWriter(sW);
        pW.println("{");
        boolean[] changedDataSpace = changes.getChangedDataSpace();
        int registersOffset = AvrImplementation.$ATMEGA32L.getRegistersOffset();
        int ioOffset = AvrImplementation.$ATMEGA32L.getIORegistersOffset();
        int sramOffset = AvrImplementation.$ATMEGA32L.getSRamOffset();
        for (i = 0; i < AvrImplementation.$ATMEGA32L.getNumRegisters(); ++i) {
            if (!changedDataSpace[registersOffset + i]) continue;
            pW.printf("\t* r%d\t=\t0x%02x <- 0x%02x\n", i, this.dataSpace[registersOffset + i], other.dataSpace[registersOffset + i]);
        }
        pW.println("\t-----------");
        for (i = 0; i < AvrImplementation.$ATMEGA32L.getNumIORegisters(); ++i) {
            if (!changedDataSpace[ioOffset + i]) continue;
            pW.printf("\t* io[%02d]\t=\t0x%02x <- 0x%02x\n", i, this.dataSpace[ioOffset + i], other.dataSpace[ioOffset + i]);
        }
        pW.println("\t-----------");
        for (i = 0; i < AvrImplementation.$ATMEGA32L.getSRamSize(); ++i) {
            if (!changedDataSpace[sramOffset + i]) continue;
            pW.printf("\t* sram[%05d]\t=\t0x%02x <- 0x%02x\n", i, this.dataSpace[sramOffset + i], other.dataSpace[sramOffset + i]);
        }
        pW.println("}");
        return sW.toString();
    }

    public String diff(AvrChipState other) {
        return this.diff(other, this.changed(other));
    }

    public boolean equals(Object other) {
        AvrChipState otherState = (AvrChipState)other;
        for (int i = 0; i < this.dataSpace.length; ++i) {
            if (this.dataSpace[i] == otherState.dataSpace[i]) continue;
            return false;
        }
        return true;
    }
}

