/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.builder.statement;

import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.StatementCollection;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.builder.Builder;
import rreil.gdsl.builder.StatementCollectionBuilder;
import rreil.gdsl.builder.sexpr.SexprBuilder;
import rreil.gdsl.builder.statement.StatementBuilder;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;
import rreil.lang.util.RhsFactory;

public class IteBuilder
extends StatementBuilder {
    private SexprBuilder cond;
    private StatementCollectionBuilder then_branch;
    private StatementCollectionBuilder else_branch;

    public IteBuilder(BuildingStateManager manager, SexprBuilder cond, StatementCollectionBuilder then_branch, StatementCollectionBuilder else_branch) {
        super(manager);
        this.cond = cond.size(1);
        this.then_branch = then_branch;
        this.else_branch = else_branch;
    }

    @Override
    public BuildResult<? extends RReil> build() {
        BuildResult<? extends Rhs.SimpleExpression> condR = this.cond.build();
        RReilAddr branchThenAddress = this.manager.nextAddress();
        BuildResult<StatementCollection> elseR = this.else_branch.build();
        RReilAddr branchEndAddr = this.manager.nextAddress();
        RReilAddr staged = this.manager.stageAddress();
        RReil.BranchToRReil branchThenRReil = RReilFactory.instance.branch(branchThenAddress, condR.getResult(), RhsFactory.getInstance().rreilAddress(64, staged));
        BuildResult<StatementCollection> thenR = this.then_branch.build();
        RReilAddr behindAddr = this.manager.stageAddress();
        RReil.BranchToRReil branchEndRReil = RReilFactory.instance.branch(branchEndAddr, RhsFactory.getInstance().trueLin(), RhsFactory.getInstance().rreilAddress(64, behindAddr));
        SortedMap<RReilAddr, RReil> stmts = condR.getStatements();
        stmts.putAll(elseR.getResult().getInstructions());
        stmts.putAll(thenR.getResult().getInstructions());
        stmts.put(branchEndRReil.getRReilAddress(), branchEndRReil);
        return IteBuilder.result(branchThenRReil, stmts);
    }

    @Override
    public Builder<RReil> size(int size) {
        throw new RuntimeException("No size field");
    }

    @Override
    public int getSize() {
        throw new RuntimeException("No size field");
    }
}

