/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.builder.statement;

import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.builder.VariableBuilder;
import rreil.gdsl.builder.expression.ExpressionBuilder;
import rreil.gdsl.builder.statement.StatementBuilder;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;

public class AssignBuilder
extends StatementBuilder {
    private VariableBuilder lhsBuilder;
    private ExpressionBuilder rhsBuilder;

    public AssignBuilder(BuildingStateManager manager, int size, VariableBuilder lhsBuilder, ExpressionBuilder rhsBuilder) {
        super(manager);
        this.lhsBuilder = lhsBuilder;
        this.rhsBuilder = rhsBuilder;
        this.size(size);
    }

    @Override
    public BuildResult<RReil.Assign> build() {
        BuildResult<Rhs.Rvar> lhs = this.lhsBuilder.build();
        BuildResult rhs = this.rhsBuilder.build();
        SortedMap<RReilAddr, RReil> stmts = lhs.before(rhs);
        RReil.Assign stmt = RReilFactory.instance.assign(this.manager.nextAddress(), lhs.getResult().asLhs(), (Rhs)rhs.getResult());
        return AssignBuilder.result(stmt, stmts);
    }

    public AssignBuilder size(int size) {
        this.rhsBuilder.size(size);
        this.lhsBuilder.size(this.rhsBuilder.getSize());
        return this;
    }

    @Override
    public int getSize() {
        return this.lhsBuilder.getSize();
    }
}

