/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class RepTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final InsnTranslator translator;

    public RepTranslator(InsnTranslator translator) {
        this.translator = translator;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd cx = registerTranslator.translateRegister("ecx").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd cxZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
        LowLevelRReilOpnd zero = factory.immediate(cx.size(), (Number)0);
        LowLevelRReilOpnd one = factory.immediate(cx.size(), (Number)1);
        ArrayList<LowLevelRReil> inner = new ArrayList<LowLevelRReil>();
        RReilAddr addr1 = env.getNextReilAddress();
        RReilAddr addr2 = env.getNextReilAddress();
        this.translator.translate(env, instruction, inner);
        long base = env.getBaseAddress();
        long innerLen = inner.size();
        long done = 4L + innerLen;
        instructions.addAll(Arrays.asList(factory.CMPEQ(addr1, cxZero, cx, zero), factory.IFGOTORREIL(addr2, cxZero, base, done)));
        instructions.addAll(inner);
        instructions.addAll(Arrays.asList(factory.SUB(env.getNextReilAddress(), cx, cx, one), factory.GOTORREIL(env.getNextReilAddress(), base, 0L), factory.NOP(env.getNextReilAddress())));
    }
}

