/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.CondEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class LoopTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    public static final CondEmitter LOOP = new LoopEmitter();
    public static final CondEmitter LOOPE = new LoopeEmitter();
    public static final CondEmitter LOOPNE = new LoopneEmitter();
    private final CondEmitter emitter;

    public LoopTranslator(CondEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        env.setCurrentInstruction(instruction);
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, targetOperand);
        LowLevelRReilOpnd target = opnd1.getOperandStack().pop();
        LowLevelRReilOpnd cx = registerTranslator.translateRegister("ecx").withSize(env.getDefaultArchitectureSize());
        instructions.add(factory.SUB(env.getNextReilAddress(), cx, cx, factory.immediate(cx.size(), (Number)1)));
        LowLevelRReilOpnd cond = this.emitter.emit(env, instructions);
        instructions.add(factory.IFGOTO(env.getNextReilAddress(), cond, target));
    }

    public static class LoopneEmitter
    implements CondEmitter {
        @Override
        public LowLevelRReilOpnd emit(TranslationCtx env, List<LowLevelRReil> insns) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd cx = registerTranslator.translateRegister("ecx").withSize(env.getDefaultArchitectureSize());
            LowLevelRReilOpnd zero = factory.immediate(cx.size(), (Number)0);
            LowLevelRReilOpnd cxZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cxNZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd ne = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cond = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            insns.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), cxZero, cx, zero), factory.NOT(env.getNextReilAddress(), cxNZero, cxZero), factory.NOT(env.getNextReilAddress(), ne, X86Helpers.EQUAL_FLAG_OPERAND), factory.AND(env.getNextReilAddress(), cond, cxNZero, ne)));
            return cond;
        }
    }

    public static class LoopeEmitter
    implements CondEmitter {
        @Override
        public LowLevelRReilOpnd emit(TranslationCtx env, List<LowLevelRReil> insns) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd cx = registerTranslator.translateRegister("ecx").withSize(env.getDefaultArchitectureSize());
            LowLevelRReilOpnd zero = factory.immediate(cx.size(), (Number)0);
            LowLevelRReilOpnd cxZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cxNZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cond = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            insns.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), cxZero, cx, zero), factory.NOT(env.getNextReilAddress(), cxNZero, cxZero), factory.AND(env.getNextReilAddress(), cond, cxNZero, X86Helpers.EQUAL_FLAG_OPERAND)));
            return cond;
        }
    }

    public static class LoopEmitter
    implements CondEmitter {
        @Override
        public LowLevelRReilOpnd emit(TranslationCtx env, List<LowLevelRReil> insns) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd cx = registerTranslator.translateRegister("ecx").withSize(env.getDefaultArchitectureSize());
            LowLevelRReilOpnd zero = factory.immediate(cx.size(), (Number)0);
            LowLevelRReilOpnd cxZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cxNZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            insns.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), cxZero, cx, zero), factory.NOT(env.getNextReilAddress(), cxNZero, cxZero)));
            return cxNZero;
        }
    }
}

