/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.CondEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.MovTranslator;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class CmovccTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final CondEmitter emitter;
    private final InsnTranslator movTranslator = new MovTranslator();

    public CmovccTranslator(CondEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        LowLevelRReilOpnd cond = this.emitter.emit(env, instructions);
        long condOffset = env.getCurrentReilOffset();
        RReilAddr addr1 = env.getNextReilAddress();
        RReilAddr addr2 = env.getNextReilAddress();
        ArrayList<LowLevelRReil> movCode = new ArrayList<LowLevelRReil>();
        this.movTranslator.translate(env, instruction, movCode);
        long baseOffset = env.getBaseAddress();
        long takenOffset = condOffset + 2L;
        long exitOffset = (long)movCode.size() + takenOffset;
        instructions.addAll(Arrays.asList(factory.IFGOTORREIL(addr1, cond, baseOffset, takenOffset), factory.GOTORREIL(addr2, baseOffset, exitOffset)));
        instructions.addAll(movCode);
        instructions.add(factory.NOP(env.getNextReilAddress()));
    }
}

