/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.avr8.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.avr8.common.AVR8OperandTranslator;
import rreil.disassembler.translators.avr8.common.AVR8RegisterTranslator;
import rreil.disassembler.translators.avr8.common.AVR8SregMemTranslator;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public abstract class AVR8RegRegWordTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final boolean[] wordArguments;

    public AVR8RegRegWordTranslator(boolean[] wordArguments) {
        this.wordArguments = wordArguments;
    }

    public abstract void emit(TranslationCtx var1, LowLevelRReilOpnd var2, LowLevelRReilOpnd var3, LowLevelRReilOpnd var4, List<LowLevelRReil> var5);

    @Override
    public void translate(TranslationCtx ctx, Instruction insn, List<LowLevelRReil> instructions) {
        int i;
        AVR8SregMemTranslator.loadSreg(ctx, instructions);
        int numberOfArguments = insn.operands().size();
        TranslationState[] opndStates = new TranslationState[numberOfArguments];
        for (i = 0; i < opndStates.length; ++i) {
            opndStates[i] = AVR8OperandTranslator.translateOperand(ctx, insn.operand(i));
        }
        for (i = 0; i < opndStates.length; ++i) {
            assert (opndStates[i].getInstructionStack().isEmpty()) : "non-empty instruction stack for first operand";
        }
        LowLevelRReilOpnd[] ops = new LowLevelRReilOpnd[numberOfArguments];
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ops[i2] = opndStates[i2].getOperandStack().pop();
        }
        LowLevelRReilOpnd dst = ctx.temporaryRegister(OperandSize.WORD);
        LowLevelRReilOpnd t0 = ctx.temporaryRegister(dst.size());
        LowLevelRReilOpnd t1 = ctx.temporaryRegister(dst.size());
        LowLevelRReilOpnd[] args = new LowLevelRReilOpnd[numberOfArguments];
        LowLevelRReilOpnd[] opsHigh = new LowLevelRReilOpnd[numberOfArguments];
        for (int i3 = 0; i3 < args.length; ++i3) {
            if (this.wordArguments[i3]) {
                args[i3] = ctx.temporaryRegister(ops[i3].size() * 2);
                opsHigh[i3] = AVR8RegisterTranslator.$.getFollowingRegister(ops[i3]);
                instructions.add(factory.CONVERT(ctx.getNextReilAddress(), t0, opsHigh[i3]));
                instructions.add(factory.SHL(ctx.getNextReilAddress(), t0, t0, factory.immediate(t0.size(), (Number)ops[i3].size())));
                instructions.add(factory.CONVERT(ctx.getNextReilAddress(), t1, ops[i3]));
                instructions.add(factory.OR(ctx.getNextReilAddress(), args[i3], t0, t1));
                continue;
            }
            args[i3] = ops[i3];
        }
        this.emit(ctx, dst, args.length >= 1 ? args[0] : null, args.length >= 2 ? args[1] : null, instructions);
        instructions.addAll(Arrays.asList(factory.CONVERT(ctx.getNextReilAddress(), ops[0], dst)));
        instructions.addAll(Arrays.asList(factory.SHRS(ctx.getNextReilAddress(), dst, dst, factory.immediate(t0.size(), (Number)ops[0].size()))));
        instructions.addAll(Arrays.asList(factory.CONVERT(ctx.getNextReilAddress(), opsHigh[0], dst)));
        AVR8SregMemTranslator.storeSreg(ctx, instructions);
    }
}

