/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javalx.numeric.Interval;

public class OperandTree {
    private final Node root;

    public OperandTree(Node root) {
        this.root = root;
    }

    public Node getRoot() {
        return this.root;
    }

    public String toString() {
        return "Tree{" + this.root + '}';
    }

    public static final class NodeBuilder {
        private Type type;
        private Object data;
        private final List<Node> children = new LinkedList<Node>();

        public NodeBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public NodeBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public NodeBuilder link(Node child) {
            this.children.add(child);
            return this;
        }

        public Node build() {
            assert (this.type != null) : "null type";
            return new Node(this.type, this.data, this.children);
        }
    }

    public static final class Node {
        private final Type type;
        private final Object data;
        private final List<Node> children;

        private Node(Type ty, Object data, List<Node> children) {
            this.type = ty;
            this.data = data;
            this.children = Collections.unmodifiableList(children);
        }

        public Object getData() {
            return this.data;
        }

        public Type getType() {
            return this.type;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Node child(int n) {
            return this.children.get(n);
        }

        public StringBuilder asString(StringBuilder pretty) {
            switch (this.type) {
                case Immf: 
                case Immi: {
                    assert (this.children.isEmpty()) : "Invalid leaf node: immediate node has children";
                    pretty.append(((Number)this.data).toString());
                    break;
                }
                case Immr: {
                    assert (this.children.isEmpty()) : "Invalid leaf node: immediate node has children";
                    pretty.append(((Interval)this.data).toString());
                    break;
                }
                case Sym: {
                    assert (this.children.isEmpty()) : "Invalid leaf node: symbol node has children";
                    pretty.append(this.data.toString());
                    break;
                }
                case Size: {
                    pretty.append('(').append(((Number)this.data).toString());
                    for (Node n : this.children) {
                        n.asString(pretty.append(' '));
                    }
                    pretty.append(')');
                    break;
                }
                case Op: {
                    pretty.append('(').append(this.data.toString());
                    for (Node n : this.children) {
                        n.asString(pretty.append(' '));
                    }
                    pretty.append(')');
                    break;
                }
                case Mem: {
                    pretty.append('*').append(((Number)this.data).toString()).append('(');
                    Iterator<Node> it = this.children.iterator();
                    while (it.hasNext()) {
                        Node n = it.next();
                        n.asString(pretty);
                        if (!it.hasNext()) continue;
                        pretty.append(' ');
                    }
                    pretty.append(')');
                }
            }
            return pretty;
        }

        public String toString() {
            StringBuilder pretty = new StringBuilder();
            return this.asString(pretty).toString();
        }
    }

    public static enum Type {
        Size,
        Mem,
        Immf,
        Immi,
        Immr,
        Sym,
        Op;

    }
}

