/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import com.jamesmurty.utils.XMLBuilder;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.xml.XmlPrintable;

public class FiniteRange
implements Comparable<FiniteRange>,
XmlPrintable {
    private final BigInt low;
    private final BigInt high;

    private FiniteRange(BigInt lo, BigInt up) {
        this.low = lo;
        this.high = up;
        assert (this.low.isLessThanOrEqualTo(this.high)) : "Range is not well-formed: [" + lo + ", " + up + "]";
    }

    public static FiniteRange of(long c) {
        BigInt c1 = BigInt.of(c);
        return new FiniteRange(c1, c1);
    }

    public static FiniteRange of(long lo, long up) {
        return new FiniteRange(BigInt.of(lo), BigInt.of(up));
    }

    public static FiniteRange of(BigInt lo, long span) {
        return new FiniteRange(lo, lo.add(BigInt.of(span - 1L)));
    }

    public BigInt low() {
        return this.low;
    }

    public BigInt high() {
        return this.high;
    }

    @Override
    public int compareTo(FiniteRange b) {
        int cmp1 = this.low.compareTo(b.low);
        return cmp1 == 0 ? this.high.compareTo(b.high) : cmp1;
    }

    public boolean overlaps(Interval other) {
        return this.low.isLessThanOrEqualTo(other.high) && other.low.isLessThanOrEqualTo(this.high);
    }

    public FiniteRange join(FiniteRange other) {
        return new FiniteRange(this.low.min(other.low), this.high.max(other.high));
    }

    public boolean isEqualTo(FiniteRange other) {
        return this.low.isEqualTo(other.low) && this.high.isEqualTo(other.high);
    }

    public boolean equals(Object o) {
        return o instanceof FiniteRange && this.isEqualTo((FiniteRange)o);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.low.hashCode();
        hash = 23 * hash + this.high.hashCode();
        return hash;
    }

    public BigInt getSpan() {
        return this.high.sub(this.low).add(Bound.ONE);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        return builder.e("FiniteRange").t(this.toString()).up();
    }

    public String toString() {
        String fmt = "[%s:%s]";
        return String.format(fmt, this.low, this.getSpan());
    }

    public Interval toInterval() {
        return Interval.of(this.low, this.high);
    }
}

