/*
 * Decompiled with CFR 0.152.
 */
package javalx.digraph.algorithms.dfs;

import java.util.HashMap;
import javalx.digraph.Digraph;
import javalx.digraph.algorithms.dfs.DfsVertexVisitor;
import javalx.digraph.algorithms.dfs.EdgeKind;
import javalx.digraph.algorithms.dfs.VertexColor;

public class Dfs {
    private static final DfsVertexVisitor nullVisitor = new DfsVertexVisitor(){

        @Override
        public void visitWhenFinished(Digraph.Vertex v) {
        }

        @Override
        public void visitOnDiscovery(Digraph.Vertex v) {
        }
    };
    private final DfsVertexVisitor visitor;
    private HashMap<Digraph.Vertex, VertexColor> vertexColors = null;
    private HashMap<Digraph.Edge, EdgeKind> edgeKinds = null;

    public Dfs() {
        this(nullVisitor);
    }

    public Dfs(DfsVertexVisitor visitor) {
        this.visitor = visitor;
    }

    public void run(Digraph.Vertex rootVertex) {
        this.prepareState();
        this.visit(this.visitor, rootVertex);
    }

    private void prepareState() {
        this.vertexColors = new HashMap();
        this.edgeKinds = new HashMap();
    }

    private void visit(DfsVertexVisitor visitor, Digraph.Vertex v) {
        this.vertexColors.put(v, VertexColor.Gray);
        visitor.visitOnDiscovery(v);
        for (Digraph.Edge outgoingEdge : v) {
            Digraph.Vertex w = outgoingEdge.getTarget();
            switch (this.colorOfVertex(w)) {
                case White: {
                    this.visit(visitor, w);
                    break;
                }
                case Gray: {
                    this.edgeKinds.put(outgoingEdge, EdgeKind.Backward);
                    break;
                }
            }
        }
        this.vertexColors.put(v, VertexColor.Black);
        visitor.visitWhenFinished(v);
    }

    private VertexColor colorOfVertex(Digraph.Vertex v) {
        VertexColor c = this.vertexColors.get(v);
        return c == null ? VertexColor.White : c;
    }

    public boolean isBackwardEdge(Digraph.Edge edge) {
        return this.edgeKinds.get(edge) == EdgeKind.Backward;
    }
}

