/*
 * Decompiled with CFR 0.152.
 */
package gdsl.translator;

import gdsl.Frontend;
import gdsl.Gdsl;
import gdsl.decoder.NativeInstruction;
import gdsl.rreil.BuilderBackend;
import gdsl.rreil.IRReilBuilder;
import gdsl.rreil.IRReilCollection;
import gdsl.rreil.statement.IStatement;
import gdsl.translator.OptimizationConfig;
import gdsl.translator.TranslatedBlock;
import gdsl.translator.TranslatedBlockRaw;

public class Translator {
    private Gdsl gdsl;
    private BuilderBackend backend;

    public Translator(Gdsl gdsl, IRReilBuilder iRReilBuilder) {
        this.gdsl = gdsl;
        this.backend = new BuilderBackend(iRReilBuilder);
    }

    public IRReilCollection<IStatement> translate(NativeInstruction nativeInstruction) {
        return this.backend.translate(this.gdsl.getFrontendPtr(), this.gdsl.getGdslStatePtr(), nativeInstruction.getInsnPtr());
    }

    public TranslatedBlock translateOptimizeBlock(long l, OptimizationConfig optimizationConfig) {
        this.gdsl.heapManager.ref();
        Frontend frontend = this.gdsl.getFrontend();
        TranslatedBlockRaw translatedBlockRaw = frontend.isConfigured() ? this.backend.translateOptimizeBlockWithConfig(frontend.getPointer(), this.gdsl.getGdslStatePtr(), frontend.getConfig().vector(), l, optimizationConfig.getConfig()) : this.backend.translateOptimizeBlock(frontend.getPointer(), this.gdsl.getGdslStatePtr(), l, optimizationConfig.getConfig());
        long[] lArray = translatedBlockRaw.getInstructions();
        NativeInstruction[] nativeInstructionArray = new NativeInstruction[lArray.length];
        for (int i = 0; i < nativeInstructionArray.length; ++i) {
            nativeInstructionArray[i] = new NativeInstruction(this.gdsl, lArray[i]);
        }
        this.gdsl.heapManager.unref();
        return new TranslatedBlock(nativeInstructionArray, translatedBlockRaw.getRreil());
    }
}

