/*
 * Decompiled with CFR 0.152.
 */
package binparse.trace;

import binparse.Binary;
import binparse.Permission;
import binparse.Segment;
import binparse.Symbol;
import binparse.trace.TraceDump;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.FiniteRange;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;

public class Tracer {
    public static String trace(String tracerScript, String tracedCommand, String outputFile, String ... tracerOptions) throws IOException {
        if (!Tracer.fileExists(tracerScript)) {
            throw new FileNotFoundException("The tracer invocation script: \"" + tracerScript + "\" does not exist.");
        }
        if (outputFile == null || outputFile.isEmpty()) {
            outputFile = System.getProperty("user.home") + "/tracedump";
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("bash");
        commands.add(tracerScript);
        commands.add("--nocompress");
        commands.add("-o ");
        commands.add(outputFile);
        for (String option : tracerOptions) {
            commands.add(option);
        }
        commands.add(tracedCommand);
        Process tracerCall = new ProcessBuilder(commands).start();
        try {
            tracerCall.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String callNormalOutput = Tracer.getStreamOutput(tracerCall.getInputStream());
        String callErrorOutput = Tracer.getStreamOutput(tracerCall.getErrorStream());
        if (!callNormalOutput.isEmpty()) {
            System.out.println("Output:\n" + callNormalOutput);
        }
        if (!callErrorOutput.isEmpty()) {
            System.err.println("Errors:\n" + callErrorOutput);
        }
        return outputFile;
    }

    public static boolean fileExists(String filePath) {
        return new File(filePath).exists();
    }

    public static void setExecutable(String filePath) {
        new File(filePath).setExecutable(true);
    }

    private static String getStreamOutput(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder output = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            output.append(line + "\n");
        }
        reader.close();
        stream.close();
        return output.toString();
    }

    public static void dumpSegment(Segment segment, String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            fileName = System.getProperty("user.home", "") + "/" + segment.getNameOrAddress() + ".dump";
        }
        try {
            BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(fileName));
            file.write(segment.getData());
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dumpControlFlow(TraceDump traces, boolean verbose) {
        if (verbose) {
            Tracer.dumpControlFlowVerbose(traces);
        } else {
            Tracer.dumpControlFlow(traces);
        }
    }

    private static void dumpControlFlow(TraceDump traces) {
        for (P3<Long, Long, Boolean> flow : traces.getControlFlow()) {
            String condition = flow._3() != false ? "t" : "f";
            System.out.println(Long.toHexString(flow._1()) + " -" + condition + "> " + Long.toHexString(flow._2()));
        }
    }

    private static void dumpControlFlowVerbose(final TraceDump trace) {
        String lastLocationName = null;
        SegmentSymbolResolver resolver = new SegmentSymbolResolver(){
            FiniteRangeTree<Symbol> symbolAddresses;
            {
                this.symbolAddresses = Tracer.inferSymbolRanges(trace.getTracedBinary());
            }

            @Override
            public Option<Symbol> getSymbol(long address) {
                OverlappingRanges<Symbol> overlaps = this.symbolAddresses.searchOverlaps(FiniteRange.of(address));
                if (overlaps.isEmpty()) {
                    return Option.none();
                }
                if (overlaps.size() == 1) {
                    return Option.some(overlaps.getFirst()._2());
                }
                throw new IllegalStateException("More than one symbol found for address: " + address);
            }

            @Override
            public Option<Segment> getSegment(long address) {
                return trace.getTracedBinary().getSegment(address);
            }
        };
        for (P3<Long, Long, Boolean> flow : trace.getControlFlow()) {
            String fromLocationName = Tracer.formatLocationName(resolver, flow._1());
            if (!fromLocationName.equals(lastLocationName)) {
                System.out.println(" " + fromLocationName);
            }
            String toLocationName = Tracer.formatLocationName(resolver, flow._2());
            String fromAddress = Long.toHexString(flow._1());
            String toAddress = Long.toHexString(flow._2());
            String condition = flow._3() != false ? "t" : "f";
            String toLocationChanged = "";
            if (!toLocationName.equals(fromLocationName)) {
                toLocationChanged = "     " + toLocationName;
            }
            System.out.println(fromAddress + " -" + condition + "> " + toAddress + toLocationChanged);
            lastLocationName = toLocationName;
        }
    }

    private static FiniteRangeTree<Symbol> inferSymbolRanges(Binary binary) {
        FiniteRangeTree<Symbol> symbolAddresses = FiniteRangeTree.empty();
        symbolAddresses = Tracer.setSymbolStartAddresses(symbolAddresses, binary.getImportedSymbols());
        symbolAddresses = Tracer.setSymbolStartAddresses(symbolAddresses, binary.getExportedSymbols());
        FiniteRangeTree<Symbol> symbolRanges = FiniteRangeTree.empty();
        Iterator<P2<FiniteRange, Symbol>> iter = symbolAddresses.iterator();
        P2<FiniteRange, Symbol> cachedNextSymbol = null;
        while (iter.hasNext() || cachedNextSymbol != null) {
            long endAddress;
            long startAddress;
            P2<FiniteRange, Symbol> symbol;
            P2<FiniteRange, Symbol> p2 = symbol = cachedNextSymbol != null ? cachedNextSymbol : iter.next();
            if (iter.hasNext()) {
                P2<FiniteRange, Symbol> successorSymbol = iter.next();
                startAddress = symbol._1().low().asInteger().longValue();
                endAddress = successorSymbol._1().low().asInteger().longValue() - 1L;
                cachedNextSymbol = successorSymbol;
            } else {
                cachedNextSymbol = null;
                startAddress = symbol._1().low().asInteger().longValue();
                endAddress = Math.max(startAddress, Tracer.getHighestExecutableAddress(binary));
            }
            symbolRanges = symbolRanges.bind(FiniteRange.of(startAddress, endAddress), symbol._2());
        }
        return symbolRanges;
    }

    private static long getHighestExecutableAddress(Binary binary) {
        long maxAddress = 0L;
        for (Segment segment : binary.getSegments()) {
            if (!Permission.isExecutable(segment.getPermissions()) || segment.getAddress() <= maxAddress) continue;
            maxAddress = segment.getAddress();
        }
        return maxAddress;
    }

    private static FiniteRangeTree<Symbol> setSymbolStartAddresses(FiniteRangeTree<Symbol> symbolRanges, List<Symbol> symbols) {
        for (Symbol symbol : symbols) {
            symbolRanges = symbolRanges.bind(FiniteRange.of(symbol.getAddress()), symbol);
        }
        return symbolRanges;
    }

    private static String formatLocationName(SegmentSymbolResolver resolver, Long address) {
        String symbol = Tracer.formatSymbolName(resolver.getSymbol(address));
        String segment = Tracer.formatSegmentName(resolver.getSegment(address));
        return symbol + "          " + segment;
    }

    private static String formatSymbolName(Option<Symbol> symbol) {
        if (symbol.isNone()) {
            return "(unknown symbol)";
        }
        return symbol.get().getNameOrAddress();
    }

    private static String formatSegmentName(Option<Segment> segment) {
        if (segment.isNone()) {
            return "(unknown segment)";
        }
        return segment.get().toString() + "       " + segment.get().getFileName().getOrElse("");
    }

    private static interface SegmentSymbolResolver {
        public Option<Symbol> getSymbol(long var1);

        public Option<Segment> getSegment(long var1);
    }
}

