/*
 * Decompiled with CFR 0.152.
 */
package binparse.trace;

import binparse.Endianness;
import binparse.Permission;
import binparse.Segment;
import binparse.SegmentImpl;
import binparse.UncheckedIOException;
import binparse.trace.TraceSerializer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import javalx.data.products.P3;
import javalx.numeric.BigInt;

class TraceParser {
    TraceParser() {
    }

    public static TraceSerializer.TraceInfo parseInfo(String file) {
        return TraceParser.parseTraceDumps(file, new Parser<TraceSerializer.TraceInfo>(){

            @Override
            public TraceSerializer.TraceInfo parse(InputStream input) {
                try {
                    return TraceSerializer.TraceInfo.parseFrom(input);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    public static Map<String, BigInt> parseRegisters(String file) {
        return TraceParser.parseTraceDumps(file, new Parser<Map<String, BigInt>>(){

            @Override
            public Map<String, BigInt> parse(InputStream input) {
                return TraceParser.parseRegisters(input);
            }
        });
    }

    private static Map<String, BigInt> parseRegisters(InputStream input) {
        HashMap<String, BigInt> registers = new HashMap<String, BigInt>();
        try {
            TraceSerializer.CPUState cpuState = TraceSerializer.CPUState.parseFrom(input);
            for (TraceSerializer.CPUState.Register reg : cpuState.getRegistersList()) {
                registers.put(reg.getName(), BigInt.of(reg.getValue()));
            }
            return registers;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Segment parseSegment(String file) {
        return TraceParser.parseTraceDumps(file, new Parser<Segment>(){

            @Override
            public Segment parse(InputStream input) {
                return TraceParser.parseSegment(input);
            }
        });
    }

    private static Segment parseSegment(InputStream input) {
        try {
            TraceSerializer.Module.Segment rawSegment = TraceSerializer.Module.Segment.parseFrom(input);
            return TraceParser.convertSegment(rawSegment);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<Segment> parseModule(String file) {
        return TraceParser.parseTraceDumps(file, new Parser<List<Segment>>(){

            @Override
            public List<Segment> parse(InputStream input) {
                return TraceParser.parseModule(input);
            }
        });
    }

    private static List<Segment> parseModule(InputStream input) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        try {
            TraceSerializer.Module module = TraceSerializer.Module.parseFrom(input);
            for (TraceSerializer.Module.Segment rawSegment : module.getSegmentsList()) {
                Segment segment = TraceParser.convertSegment(rawSegment);
                segments.add(segment);
            }
            return segments;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<P3<Long, Long, Boolean>> parseControlFlow(String file) {
        return TraceParser.parseTraceDumps(file, new Parser<List<P3<Long, Long, Boolean>>>(){

            @Override
            public List<P3<Long, Long, Boolean>> parse(InputStream input) {
                return TraceParser.parseControlFlow(input);
            }
        });
    }

    private static List<P3<Long, Long, Boolean>> parseControlFlow(InputStream input) {
        ArrayList<P3<Long, Long, Boolean>> jumps = new ArrayList<P3<Long, Long, Boolean>>();
        try {
            TraceSerializer.ControlFlowTrace trace = TraceSerializer.ControlFlowTrace.parseFrom(input);
            for (TraceSerializer.ControlFlowTrace.ControlFlow jump : trace.getJumpsList()) {
                long currentPC = jump.getCurrentPC();
                long nextPC = jump.getNextPC();
                boolean jumpTaken = jump.getJumpConditionWas();
                jumps.add(P3.tuple3(currentPC, nextPC, jumpTaken));
            }
            return jumps;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String parseControlFlowDebug(String file) {
        return TraceParser.parseTraceDumps(file, new Parser<String>(){

            @Override
            public String parse(InputStream input) {
                return TraceParser.parseControlFlowDebug(input);
            }
        });
    }

    private static String parseControlFlowDebug(InputStream input) {
        try {
            return new Scanner(input).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    private static Segment convertSegment(TraceSerializer.Module.Segment rawSegment) {
        long address = rawSegment.getAddress();
        int size = rawSegment.getSize();
        Endianness endianness = TraceParser.convertEndianness(rawSegment.getEndianness());
        byte[] data = rawSegment.hasData() ? rawSegment.getData().toByteArray() : new byte[]{};
        Set<Permission> permissions = rawSegment.hasPermissions() ? TraceParser.decodePermissions(rawSegment.getPermissions()) : EnumSet.allOf(Permission.class);
        String name = null;
        if (rawSegment.hasName()) {
            name = rawSegment.getName();
        }
        String fileName = null;
        if (rawSegment.hasFileName()) {
            fileName = rawSegment.getFileName();
        }
        return new SegmentImpl(fileName, name, address, size, data, endianness, permissions);
    }

    private static Endianness convertEndianness(TraceSerializer.Module.Segment.Endianness endianness) {
        switch (endianness) {
            case LITTLE: {
                return Endianness.LITTLE;
            }
            case BIG: {
                return Endianness.BIG;
            }
        }
        throw new IllegalArgumentException("Endianness enumeration value unknown.");
    }

    private static Set<Permission> decodePermissions(int permissions) {
        EnumSet<Permission> decodedPermissions = EnumSet.noneOf(Permission.class);
        if ((permissions & 1) == 1) {
            decodedPermissions.add(Permission.Execute);
        }
        if ((permissions >> 1 & 1) == 1) {
            decodedPermissions.add(Permission.Write);
        }
        if ((permissions >> 2 & 1) == 1) {
            decodedPermissions.add(Permission.Read);
        }
        return decodedPermissions;
    }

    private static <T> T parseTraceDumps(String file, Parser<T> parser) {
        T t;
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            t = parser.parse(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t;
    }

    private static interface Parser<T> {
        public T parse(InputStream var1);
    }
}

