/*
 * Decompiled with CFR 0.152.
 */
package binparse.trace;

import binparse.AbstractBinary;
import binparse.Binary;
import binparse.BinaryFileFormat;
import binparse.BinaryType;
import binparse.Endianness;
import binparse.Segment;
import binparse.Symbol;
import binparse.trace.TraceDump;
import java.io.File;
import java.util.ArrayList;
import javalx.data.Option;
import javalx.numeric.FiniteRange;

public class TraceBinary
extends AbstractBinary {
    private final Binary tracedBinary;
    private final TraceDump traceDump;

    public TraceBinary(String tracesPrefix, Binary tracedBinary) {
        this.tracedBinary = tracedBinary;
        this.traceDump = new TraceDump(tracesPrefix, tracedBinary);
    }

    @Override
    public Option<File> getFile() {
        return Option.none();
    }

    @Override
    public String getFileName() {
        return this.tracedBinary.getFileName();
    }

    @Override
    public String getArchitectureName() {
        return this.tracedBinary.getArchitectureName();
    }

    @Override
    public int getArchitectureSize() {
        return this.tracedBinary.getArchitectureSize();
    }

    @Override
    public Endianness getEndianness() {
        return this.tracedBinary.getEndianness();
    }

    @Override
    public BinaryType getType() {
        return BinaryType.TraceDump;
    }

    @Override
    public BinaryFileFormat getFileFormat() {
        return BinaryFileFormat.TRACE;
    }

    @Override
    public long getEntryAddress() {
        return this.tracedBinary.getEntryAddress();
    }

    @Override
    public boolean hasDebugInformation() {
        return this.tracedBinary.hasDebugInformation();
    }

    @Override
    public Option<Symbol> getMainFunction() {
        return this.tracedBinary.getMainFunction();
    }

    public TraceDump getTraceDump() {
        return this.traceDump;
    }

    public Binary getTracedBinary() {
        return this.tracedBinary;
    }

    @Override
    protected void initSegments() {
        this.segments = new ArrayList();
        for (Segment segment : this.traceDump.getSegments()) {
            this.segments.add(segment);
            if (segment.getName().isSome()) {
                this.segmentNames.put(segment.getName().get(), segment);
            }
            long address = segment.getAddress();
            this.segmentAddresses = this.segmentAddresses.bind(FiniteRange.of(address, address + segment.getSize() - 1L), segment);
        }
    }

    @Override
    protected void initExportedSymbols() {
        this.exportedSymbols = this.tracedBinary.getExportedSymbols();
        for (Symbol symbol : this.exportedSymbols) {
            this.symbolAddresses.put(symbol.getAddress(), symbol);
            this.symbolNames.put(symbol.getName().getOrNull(), symbol);
        }
    }

    @Override
    protected void initImportedSymbols() {
        this.importedSymbols = this.tracedBinary.getImportedSymbols();
        for (Symbol symbol : this.importedSymbols) {
            this.symbolAddresses.put(symbol.getAddress(), symbol);
            this.symbolNames.put(symbol.getName().getOrNull(), symbol);
        }
    }
}

