/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.x32;

import bindis.x86.common.X86ControlRegisters;
import bindis.x86.common.X86DebugRegisters;
import bindis.x86.common.X86FloatRegisters;
import bindis.x86.common.X86MMXRegisters;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86Prefixes;
import bindis.x86.common.X86RegisterSet;
import bindis.x86.common.X86SegmentRegisters;
import bindis.x86.common.X86XMMRegisters;
import bindis.x86.x32.X32Registers;

public class X32RegisterSet
implements X86RegisterSet {
    public static final X32RegisterSet $ = new X32RegisterSet();

    private X32RegisterSet() {
    }

    @Override
    public X86Operand getGPR8(X86Prefixes prefix, int n) {
        return X32Registers.getRegister8(n);
    }

    @Override
    public X86Operand getGPR16(X86Prefixes prefix, int n) {
        return X32Registers.getRegister16(n);
    }

    @Override
    public int getArchitectureSize() {
        return 32;
    }

    @Override
    public X86Operand getGPR32(X86Prefixes prefix, int n) {
        return X32Registers.getRegister32(n);
    }

    @Override
    public X86Operand getGPR64(X86Prefixes prefixes, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public X86Operand getGPR(X86Prefixes prefix, int n) {
        if (prefix.contains(X86Prefixes.Prefix.OPNDSZ)) {
            return X32Registers.getRegister16(n);
        }
        return X32Registers.getRegister32(n);
    }

    @Override
    public X86Operand getGPRAsAddressPart(X86Prefixes prefixes, int n) {
        boolean addrSz = prefixes.contains(X86Prefixes.Prefix.ADDRSZ);
        if (addrSz) {
            return X32Registers.getRegister16(n);
        }
        return X32Registers.getRegister32(n);
    }

    @Override
    public X86Operand getXMMRegister(X86Prefixes prefix, int n) {
        return X86XMMRegisters.getRegister(n);
    }

    @Override
    public X86Operand getMMXRegister(X86Prefixes prefix, int n) {
        return X86MMXRegisters.getRegister(n);
    }

    @Override
    public X86Operand getSegmentRegister(X86Prefixes prefix, int n) {
        return X86SegmentRegisters.getSegmentRegister(n);
    }

    @Override
    public X86Operand getFloatingPointRegister(X86Prefixes prefixes, int n) {
        return X86FloatRegisters.getRegister(n);
    }

    @Override
    public X86Operand getControlRegister(X86Prefixes prefixes, int n) {
        return X86ControlRegisters.getRegister(n);
    }

    @Override
    public X86Operand getDebugRegister(X86Prefixes prefixes, int n) {
        return X86DebugRegisters.getRegister(n);
    }

    @Override
    public boolean is64BitArchitecture() {
        return false;
    }

    @Override
    public int effectiveMemoryAccessSize(X86Prefixes prefix, int opndType) {
        boolean operandSize = prefix.contains(X86Prefixes.Prefix.OPNDSZ);
        boolean addressSize = prefix.contains(X86Prefixes.Prefix.ADDRSZ);
        switch (opndType) {
            case 2: {
                return 8;
            }
            case 1: 
            case 15: {
                return X32RegisterSet.chooseSz(operandSize, 16, 32);
            }
            case 16: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 6: {
                return X32RegisterSet.chooseSz(operandSize, 32, 48);
            }
            case 5: {
                return 128;
            }
            case 9: {
                return 128;
            }
            case 7: {
                return 128;
            }
            case 10: 
            case 12: {
                return 64;
            }
            case 14: {
                return 32;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int effectiveAddressSize(X86Prefixes prefix, int opndType) {
        int size = this.getArchitectureSize();
        switch (opndType) {
            case 1: 
            case 15: {
                size = prefix.contains(X86Prefixes.Prefix.ADDRSZ) ? 16 : 32;
            }
        }
        return size;
    }

    private static int chooseSz(boolean operandSz, int ifTrue, int ifFalse) {
        return operandSz ? ifTrue : ifFalse;
    }
}

