/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86RegOpnd;

public class X86XMMRegisters {
    public static final int NUM_XMM_REGISTERS = 8;
    public static final X86RegOpnd XMM0 = new X86RegOpnd("xmm0", 128);
    public static final X86RegOpnd XMM1 = new X86RegOpnd("xmm1", 128);
    public static final X86RegOpnd XMM2 = new X86RegOpnd("xmm2", 128);
    public static final X86RegOpnd XMM3 = new X86RegOpnd("xmm3", 128);
    public static final X86RegOpnd XMM4 = new X86RegOpnd("xmm4", 128);
    public static final X86RegOpnd XMM5 = new X86RegOpnd("xmm5", 128);
    public static final X86RegOpnd XMM6 = new X86RegOpnd("xmm6", 128);
    public static final X86RegOpnd XMM7 = new X86RegOpnd("xmm7", 128);
    private static X86RegOpnd[] xmmRegisters = new X86RegOpnd[]{XMM0, XMM1, XMM2, XMM3, XMM4, XMM5, XMM6, XMM7};

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static String getRegisterName(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid XMM register number";
        return xmmRegisters[regNum].toString();
    }

    public static X86RegOpnd getRegister(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid XMM register number";
        return xmmRegisters[regNum];
    }
}

