/*
 * Decompiled with CFR 0.152.
 */
package bindis.gdsl;

import bindis.INativeInstruction;
import bindis.gdsl.GdslInstruction;
import bindis.gdsl.GdslOperand;
import gdsl.decoder.NativeInstruction;
import gdsl.translator.Translator;
import java.util.ArrayList;
import javalx.exceptions.UnimplementedException;
import rreil.disassembler.Instruction;
import rreil.disassembler.OpcodeFormatter;
import rreil.disassembler.OperandTree;

public class GdslNativeInstruction
implements INativeInstruction {
    private final NativeInstruction gdslInsn;
    private final byte[] opcode;
    private final long address;
    private final GdslOperand[] operands;
    private final Translator rreilTranslator;

    public GdslNativeInstruction(NativeInstruction gdslInsn, byte[] opcode, long address, Translator rreilTranslator) {
        this.gdslInsn = gdslInsn;
        this.opcode = opcode;
        this.address = address;
        this.rreilTranslator = rreilTranslator;
        this.operands = new GdslOperand[gdslInsn.operands()];
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i] = new GdslOperand(gdslInsn, i);
        }
    }

    @Override
    public Instruction toTreeInstruction() {
        ArrayList<OperandTree> operands = new ArrayList<OperandTree>();
        for (int i = 0; i < this.operands.length; ++i) {
            OperandTree.NodeBuilder builder = new OperandTree.NodeBuilder();
            builder.type(OperandTree.Type.Op).data(this.operands[i]);
            operands.add(new OperandTree(builder.build()));
        }
        return new GdslInstruction(this.address, this.opcode, this.gdslInsn, operands, this.rreilTranslator);
    }

    @Override
    public String architecture() {
        throw new UnimplementedException();
    }

    @Override
    public String mnemonic() {
        return this.gdslInsn.mnemonic();
    }

    @Override
    public byte[] opcode() {
        return this.opcode;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public GdslOperand operand(int idx) {
        return this.operands[idx];
    }

    @Override
    public int numberOfOperands() {
        return this.operands.length;
    }

    public GdslOperand[] operands() {
        return this.operands;
    }

    @Override
    public int length() {
        return (int)this.gdslInsn.getSize() * 8;
    }

    @Override
    public StringBuilder asString(StringBuilder pretty) {
        return pretty.append(this.gdslInsn.toString());
    }

    @Override
    public StringBuilder opcode(StringBuilder buf) {
        return OpcodeFormatter.format(this.opcode, buf);
    }

    @Override
    public StringBuilder address(StringBuilder buf) {
        return buf.append(String.format("%08x", this.address));
    }
}

