/*
 * Decompiled with CFR 0.152.
 */
package bindis.avr8;

import bindis.DecodeCtx;
import bindis.DecodeStream;
import rreil.disassembler.OpcodeFormatter;

public final class AVRDecodeCtx
extends DecodeCtx {
    private int insnWord = -1;
    private int insnParameterWord = -1;

    public AVRDecodeCtx(DecodeStream stream, int startPc) {
        super(stream, startPc);
    }

    public int getInsnWord() {
        if (this.insnWord == -1) {
            this.insnWord = this.getDecodeStream().read16();
        }
        return this.insnWord;
    }

    public int getInsnParameterWord() {
        if (this.insnParameterWord == -1) {
            this.insnParameterWord = this.getDecodeStream().read16();
        }
        return this.insnParameterWord;
    }

    @Override
    public String toErrorString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{pc: 0x").append(Long.toHexString(this.getStartPc()));
        builder.append(", consumed-bytes: <");
        OpcodeFormatter.format(this.getDecodeStream().slice(), builder);
        builder.append('>');
        builder.append('}');
        return builder.toString();
    }
}

