/*
 * Decompiled with CFR 0.152.
 */
package bindis;

import bindis.DecodeException;
import bindis.DecodeStream;
import bindis.NativeDisassembler;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;
import rreil.disassembler.BlockOfInstructions;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.TranslationException;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public abstract class Disassembler {
    private final String architectureName;
    private final int registerBaseSize;
    private final ByteOrder byteOrder;
    private final NativeDisassembler nativeDisassembler;

    public Disassembler(String name, int baseSize, NativeDisassembler dis, ByteOrder byteOrder) {
        this.architectureName = name;
        this.nativeDisassembler = dis;
        this.registerBaseSize = baseSize;
        this.byteOrder = byteOrder;
    }

    public String getArchitectureName() {
        return this.architectureName;
    }

    public abstract Instruction decodeOne(DecodeStream var1, long var2) throws DecodeException;

    public Instruction decodeOne(byte[] code, int offset, long pc) throws DecodeException {
        DecodeStream in = new DecodeStream(code, offset);
        in.order(ByteOrder.LITTLE_ENDIAN);
        return this.decodeOne(in, pc);
    }

    public BlockOfInstructions decodeBlock(DecodeStream in, long pc) throws DecodeException {
        return new BlockOfOneInstruction(this.decodeOne(in, pc));
    }

    public BlockOfInstructions decodeBlock(byte[] code, int offset, long pc) throws DecodeException {
        DecodeStream in = new DecodeStream(code, offset);
        in.order(ByteOrder.LITTLE_ENDIAN);
        return this.decodeBlock(in, pc);
    }

    public abstract LowLevelRReilOpnd translateIdentifier(String var1) throws TranslationException;

    public NativeDisassembler getNativeDisassembler() {
        return this.nativeDisassembler;
    }

    public int defaultArchitectureSize() {
        return this.registerBaseSize;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private static class BlockOfOneInstruction
    implements BlockOfInstructions {
        private final Instruction insn;

        public BlockOfOneInstruction(Instruction insn) {
            this.insn = insn;
        }

        @Override
        public List<Instruction> getInstructions() {
            return Collections.singletonList(this.insn);
        }

        @Override
        public List<LowLevelRReil> toRReilInstructions() throws TranslationException {
            return this.insn.toRReilInstructions();
        }

        @Override
        public int byteLength() {
            return this.insn.length();
        }
    }
}

