/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.abi;

import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.abi.ABI;
import bindead.environment.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javalx.data.products.P2;
import javalx.numeric.Range;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class X64SysVAbi
extends ABI {
    private static final String tempReg = "tmpReg_" + X64SysVAbi.class.getSimpleName();
    private static final String[] CLIB_PARAM_REGISTERS = new String[]{"rdi", "rsi", "rdx", "rcx", "r8", "r9"};
    public static final String CLIB_RETURN_REGISTERS_1 = "rax";
    public static final String CLIB_RETURN_REGISTERS_2 = "rdi";
    private static final String[] SYSCALL_INPUT_REGISTERS = new String[]{"rdi", "rsi", "rdx", "r10", "r8", "r9"};
    private static final String SYSCALL_RET_REGISTER = "rax";
    private static final String SYSCALL_NR_REGISTER = "rax";

    public X64SysVAbi(Platform platform) {
        super(platform);
    }

    public FunctionParameterAllocations getParameterAllocationsFor(RootDomain<?> state, EParamType retType, EParamType ... paramTypes) {
        return this.getParameterAllocationsFor(state, new FunctionSignature(retType, paramTypes));
    }

    public FunctionParameterAllocations getParameterAllocationsFor(RootDomain<?> state, FunctionSignature signature) {
        Platform platform = this.getPlatform();
        EParamType retType = signature.getReturnType();
        P2<Rhs.Rvar, EParamType> retVar = null;
        switch (retType) {
            case INTEGER: {
                retVar = P2.tuple2(platform.getRegisterAsVariable("rax"), retType);
                break;
            }
            case MEMORY: {
                retVar = P2.tuple2(platform.getRegisterAsVariable(CLIB_RETURN_REGISTERS_2), retType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only parameter types INTEGER and MEMORY are allowed, yet!");
            }
        }
        int stackParamIndex = 0;
        int registerParamIndex = 0;
        ArrayList<P2<Rhs.Rvar, EParamType>> params = new ArrayList<P2<Rhs.Rvar, EParamType>>();
        block8: for (EParamType param : signature.getParamTypes()) {
            switch (param) {
                case INTEGER: {
                    params.add(P2.tuple2(this.getFunctionParameterRegisterAllocation(registerParamIndex), param));
                    ++registerParamIndex;
                    continue block8;
                }
                case MEMORY: {
                    params.add(P2.tuple2(this.getFunctionParameterStackAllocation(stackParamIndex, state), param));
                    ++stackParamIndex;
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Only parameter types INTEGER and MEMORY are allowed, yet!");
        }
        return new FunctionParameterAllocations(retVar, params);
    }

    @Override
    public Rhs.Rvar getReturnParameterAllocation() {
        return this.getPlatform().getRegisterAsVariable("rax");
    }

    private Rhs.Rvar getFunctionParameterRegisterAllocation(int parameterNumber) {
        String parameterID = X64SysVAbi.getFunctionParameterRegister(parameterNumber);
        return this.getPlatform().getRegisterAsVariable(parameterID);
    }

    private static String getFunctionParameterRegister(int parameterNumber) {
        if (parameterNumber > CLIB_PARAM_REGISTERS.length - 1) {
            throw new IllegalArgumentException("Only the first 6 parameters are supported.");
        }
        String parameterID = CLIB_PARAM_REGISTERS[parameterNumber];
        return parameterID;
    }

    @Override
    public Range getFunctionParameterValue(int parameterNumber, RootDomain<?> state) {
        return state.queryRange(this.getFunctionParameterRegisterAllocation(parameterNumber));
    }

    public Range getStackParameterValue(int parameterNumber, RootDomain<?> domainState) {
        String sp = this.getPlatform().getStackPointer();
        int size = this.getPlatform().defaultArchitectureSize();
        int parameterOffset = size / 8 * parameterNumber + 8;
        String[] insns = new String[]{this.add(tempReg, sp, parameterOffset), this.load(tempReg, tempReg)};
        RootDomain state = (RootDomain)domainState.eval(insns);
        Range value = this.getValueOf(tempReg, state);
        return value;
    }

    @Override
    public <D extends RootDomain<D>> D assignFunctionParameterToRegister(int parameterNumber, String reg, D domainState) {
        String parameterReg = X64SysVAbi.getFunctionParameterRegister(parameterNumber);
        return (D)((RootDomain)domainState.eval(this.mov(reg, parameterReg)));
    }

    @Override
    public <D extends RootDomain<D>> D setRegisterAsReturnValue(String reg, D domainState) {
        return (D)((RootDomain)domainState.eval(this.mov("rax", reg)));
    }

    private Rhs.Rvar getFunctionParameterStackAllocation(int parameterNumber, RootDomain<?> state) {
        Platform platform = this.getPlatform();
        Range stackOffset = this.getCurrentStackOffset(state);
        if (!stackOffset.isConstant()) {
            throw new UnsupportedOperationException("Non-constant stack offset.");
        }
        int parameterOffset = (stackOffset.getConstantOrNull().intValue() + platform.defaultArchitectureSize() / 8 * parameterNumber + 8) * 8;
        return new Rhs.Rvar(platform.defaultArchitectureSize(), parameterOffset, platform.getStackRegion());
    }

    @Override
    public RReilAddr getReturnAddress(RootDomain<?> domainState) {
        String sp = this.getPlatform().getStackPointer();
        RootDomain state = domainState;
        Range returnAddress = this.getValueOf(tempReg, state = (RootDomain)state.eval(this.load(tempReg, sp)));
        if (!returnAddress.isConstant()) {
            throw new UnsupportedOperationException("Non-constant return address.");
        }
        return RReilAddr.valueOf(returnAddress.getConstantOrNull());
    }

    @Override
    public List<String> getSyscallInputRegisterNames() {
        return Arrays.asList(SYSCALL_INPUT_REGISTERS);
    }

    @Override
    public String getSyscallNrRegisterName() {
        return "rax";
    }

    @Override
    public String getSyscallReturnRegisterName() {
        return "rax";
    }

    public static enum EParamType {
        INTEGER,
        SSE,
        SSEUP,
        X87,
        X87UP,
        COMPLEX_X87,
        MEMORY;

    }

    public static class FunctionParameterAllocations {
        private final P2<Rhs.Rvar, EParamType> retVar;
        private final List<P2<Rhs.Rvar, EParamType>> params;

        public FunctionParameterAllocations(P2<Rhs.Rvar, EParamType> retVar, List<P2<Rhs.Rvar, EParamType>> params) {
            this.retVar = retVar;
            this.params = params;
        }

        public P2<Rhs.Rvar, EParamType> getRetVar() {
            return this.retVar;
        }

        public List<P2<Rhs.Rvar, EParamType>> getParams() {
            return this.params;
        }
    }

    public static class FunctionSignature {
        private final EParamType returnType;
        private final List<EParamType> paramTypes;

        public FunctionSignature(EParamType retType, EParamType ... paramTypes) {
            this.returnType = retType;
            this.paramTypes = Arrays.asList(paramTypes);
        }

        public List<EParamType> getParamTypes() {
            return this.paramTypes;
        }

        public EParamType getReturnType() {
            return this.returnType;
        }
    }
}

