/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.thresholds;

import bindead.analyses.ProgramAddress;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domains.widening.thresholds.Threshold;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.fn.Fn2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.MultiMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.RReilAddr;

class ThresholdsWideningState
extends FunctorState {
    protected static final ProgramPoint zeroPoint = new ProgramAddress(RReilAddr.ZERO);
    protected static final AVLSet<ProgramPoint> emptyTransformations = AVLSet.empty().add(zeroPoint);
    public static final ThresholdsWideningState EMPTY = new ThresholdsWideningState();
    private final MultiMap<Threshold, ProgramPoint> thresholds;
    private final MultiMap<NumVar, Threshold> reverse;
    private final AVLMap<ProgramPoint, Integer> wideningCounter;

    private ThresholdsWideningState() {
        this.thresholds = MultiMap.empty();
        this.reverse = MultiMap.empty();
        this.wideningCounter = AVLMap.empty();
    }

    private ThresholdsWideningState(MutableState state) {
        assert (state.isConsistent());
        this.thresholds = state.thresholds;
        this.reverse = state.reverse;
        this.wideningCounter = state.wideningCounter;
    }

    MutableState mutableCopy() {
        return new MutableState(this.thresholds, this.reverse, this.wideningCounter);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e("THRESHOLDSWIDENING");
        return builder.up();
    }

    public String toString() {
        return "#" + this.thresholds.size() + " " + this.contentToString();
    }

    private String contentToString() {
        Iterator<P2<Threshold, AVLSet<ProgramPoint>>> iterator = this.thresholds.iteratorKeyValueSet();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<Threshold, AVLSet<ProgramPoint>> element = iterator.next();
            Threshold key = element._1();
            AVLSet<ProgramPoint> value = element._2().remove(zeroPoint);
            builder.append(key);
            builder.append(" : ");
            builder.append(value);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }

    static class MutableState
    implements Iterable<Threshold> {
        MultiMap<Threshold, ProgramPoint> thresholds = MultiMap.empty();
        private MultiMap<NumVar, Threshold> reverse = MultiMap.empty();
        private AVLMap<ProgramPoint, Integer> wideningCounter = AVLMap.empty();
        private final Fn2<Integer, Integer, Integer> maxSelector = new Fn2<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer a, Integer b) {
                return Math.max(a, b);
            }
        };

        private MutableState(MultiMap<Threshold, ProgramPoint> thresholds, MultiMap<NumVar, Threshold> reverse, AVLMap<ProgramPoint, Integer> wideningCounter) {
            this.thresholds = thresholds;
            this.reverse = reverse;
            this.wideningCounter = wideningCounter;
        }

        ThresholdsWideningState immutableCopy() {
            return new ThresholdsWideningState(this);
        }

        boolean isConsistent() {
            for (Threshold threshold : this) {
                for (NumVar variable : threshold.getTest().getVars()) {
                    if (this.reverse.get(variable).contains(threshold)) continue;
                    return false;
                }
            }
            for (P2 p2 : this.reverse) {
                if (this.contains((Threshold)p2._2())) continue;
                return false;
            }
            return true;
        }

        public int getWideningNumber(ProgramPoint location) {
            return this.wideningCounter.get(location).getOrElse(0);
        }

        public void appliedNarrowingAt(ProgramPoint location) {
            Integer count = this.wideningCounter.get(location).getOrElse(0);
            this.wideningCounter = this.wideningCounter.bind((Object)location, (Object)(count + 1));
        }

        public int thresholdsSize() {
            return this.thresholds.size();
        }

        public int wideningPointsSize() {
            return this.wideningCounter.size();
        }

        public P3<MutableState, MutableState, MutableState> split(MutableState other) {
            ThreeWaySplit<MultiMap<Threshold, ProgramPoint>> narrowingSplit = this.thresholds.splitWithUnion(other.thresholds);
            MultiMap<Threshold, ProgramPoint> inBoth = this.thresholds.intersection(other.thresholds);
            inBoth = inBoth.union(narrowingSplit.inBothButDiffering());
            AVLMap<ProgramPoint, Integer> newWideningCounter = this.wideningCounter.union(this.maxSelector, other.wideningCounter);
            MultiMap<NumVar, Threshold> emptyReverse = MultiMap.empty();
            return P3.tuple3(new MutableState(narrowingSplit.onlyInFirst(), emptyReverse, newWideningCounter).rebuildReverseMapping(), new MutableState(inBoth, emptyReverse, newWideningCounter).rebuildReverseMapping(), new MutableState(narrowingSplit.onlyInSecond(), emptyReverse, newWideningCounter).rebuildReverseMapping());
        }

        public MutableState union(MutableState other) {
            MultiMap<Threshold, ProgramPoint> newThresholds = this.thresholds.union(other.thresholds);
            MultiMap<NumVar, Threshold> newReverse = this.reverse.union(other.reverse);
            AVLMap<ProgramPoint, Integer> newWideningCounter = this.wideningCounter.union(this.maxSelector, other.wideningCounter);
            return new MutableState(newThresholds, newReverse, newWideningCounter);
        }

        public void add(Threshold threshold) {
            this.add(threshold, emptyTransformations);
        }

        public void add(Threshold threshold, AVLSet<ProgramPoint> transformedAt) {
            this.thresholds = this.thresholds.add(threshold, transformedAt);
            this.addToReverse(threshold);
        }

        public void remove(Threshold threshold) {
            assert (this.contains(threshold));
            this.thresholds = this.thresholds.remove(threshold);
            this.removeFromReverse(threshold);
        }

        public void substitute(Threshold threshold, Threshold newThreshold) {
            assert (this.thresholds.contains(threshold));
            if (threshold.equals(newThreshold)) {
                return;
            }
            this.thresholds = this.thresholds.replaceKey(threshold, newThreshold);
            this.removeFromReverse(threshold);
            this.addToReverse(newThreshold);
        }

        public AVLSet<Threshold> getTresholdsContaining(NumVar variable) {
            return this.reverse.get(variable);
        }

        public AVLSet<Threshold> getTresholdsContainingAnyOf(VarSet variables) {
            AVLSet<Threshold> result = AVLSet.empty();
            for (NumVar variable : variables) {
                result = result.union(this.reverse.get(variable));
            }
            return result;
        }

        public AVLSet<Threshold> getNotTransformedHere(ProgramPoint location) {
            AVLSet<Threshold> result = AVLSet.empty();
            for (Threshold threshold : this) {
                if (this.getTransformations(threshold).contains(location)) continue;
                result = result.add(threshold);
            }
            return result;
        }

        private MutableState rebuildReverseMapping() {
            this.reverse = MultiMap.empty();
            for (Threshold threshold : this) {
                for (NumVar variable : threshold.getTest().getVars()) {
                    this.reverse = this.reverse.add(variable, threshold);
                }
            }
            return this;
        }

        private void addToReverse(Threshold threshold) {
            for (NumVar variable : threshold.getTest().getVars()) {
                this.reverse = this.reverse.add(variable, threshold);
            }
        }

        private void removeFromReverse(Threshold threshold) {
            for (NumVar variable : threshold.getTest().getVars()) {
                this.reverse = this.reverse.remove(variable, threshold);
            }
        }

        public void markTransformedAt(Threshold threshold, ProgramPoint location) {
            this.thresholds = this.thresholds.add(threshold, location);
        }

        public AVLSet<ProgramPoint> getTransformations(Threshold threshold) {
            return this.thresholds.get(threshold);
        }

        public boolean contains(Threshold threshold) {
            return this.thresholds.contains(threshold);
        }

        public Iterable<Threshold> asSet() {
            return this.thresholds.keys();
        }

        @Override
        public Iterator<Threshold> iterator() {
            return this.thresholds.keys().iterator();
        }

        public String toString() {
            return new ThresholdsWideningState(this).toString();
        }
    }
}

