/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.undef;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.abstractsyntax.finite.util.VarExtractor;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.FiniteFunctor;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.segments.warnings.UninitializedValue;
import bindead.domains.undef.UndefState;
import bindead.domains.undef.UndefStateBuilder;
import bindead.exceptions.Unreachable;
import java.util.Collection;
import java.util.LinkedList;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLSet;
import rreil.lang.ComparisonOp;
import rreil.lang.util.Type;

public final class Undef<D extends FiniteDomain<D>>
extends FiniteFunctor<UndefState, D, Undef<D>> {
    public static final String NAME = "UNDEF";
    private static final FiniteFactory finite = FiniteFactory.getInstance();

    public Undef(D child) {
        super(NAME, UndefState.empty(), child);
    }

    private Undef(UndefState state, D child) {
        super(NAME, state, child);
    }

    @Override
    public Undef<D> build(UndefState state, D childState) {
        return new Undef<D>(state, childState);
    }

    @Override
    public Undef<D> eval(Finite.Assign stmt) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        NumVar lhsVar = stmt.getLhs().getId();
        Finite.Rhs rhs = stmt.getRhs();
        VarSet rhsVars = VarExtractor.get(rhs);
        FiniteDomain newChildState = (FiniteDomain)this.childState;
        if (rhs instanceof Finite.FiniteRangeRhs && ((Finite.FiniteRangeRhs)rhs).getRange().isTop()) {
            builder.project(lhsVar);
            builder.addUndefined(lhsVar);
            newChildState = builder.applyChildOps(newChildState);
        } else if (builder.hasUndefined(rhsVars)) {
            builder.project(lhsVar);
            builder.addUndefined(lhsVar);
            newChildState = builder.applyChildOps(newChildState);
        } else {
            VarSet rhsFlags = builder.getFlagsFor(rhsVars);
            if (rhsFlags.isEmpty()) {
                builder.promoteToChild(lhsVar);
                builder.removeFromPartition(lhsVar);
                newChildState = builder.applyChildOps(newChildState);
                newChildState = newChildState.eval(stmt);
            } else if (rhsFlags.size() == 1) {
                NumVar.FlagVar rhsFlag = (NumVar.FlagVar)rhsFlags.first();
                builder.promoteToChild(lhsVar);
                VarSet lhsFlag = builder.getFlagsFor(lhsVar);
                if (!lhsFlag.isEmpty() && !lhsFlag.first().equalTo(rhsFlag)) {
                    builder.removeFromPartition(lhsVar);
                }
                builder.addToPartition(rhsFlag, lhsVar);
                newChildState = builder.applyChildOps(newChildState);
                newChildState = newChildState.eval(stmt);
            } else {
                builder.promoteToChild(lhsVar);
                NumVar.FlagVar newLhsFlag = builder.addEmptyPartition();
                newChildState = builder.applyChildOps(newChildState);
                int size = 1;
                Finite.Rlin sumOfFlags = finite.linear(size, Undef.buildSumOfVars(rhsFlags));
                Finite.Rlin numberOfFlags = finite.literal(size, BigInt.of(rhsFlags.size()));
                Finite.Cmp cmp = finite.comparison(sumOfFlags, ComparisonOp.Cmpeq, numberOfFlags);
                Finite.Lhs lhs = finite.variable(size, newLhsFlag);
                newChildState = newChildState.eval(finite.assign(lhs, cmp));
                builder.reduceWithQuery(newChildState, rhsFlags);
                builder.removeFromPartition(lhsVar);
                if (builder.isFlag(newLhsFlag)) {
                    builder.addToPartition(newLhsFlag, lhsVar);
                }
                newChildState = builder.applyChildOps(newChildState);
                newChildState = newChildState.eval(stmt);
            }
        }
        return this.build(builder.build(), (D)newChildState);
    }

    private static Linear buildSumOfVars(VarSet variables) {
        Linear sum = Linear.ZERO;
        for (NumVar var : variables) {
            sum = sum.add(var);
        }
        return sum;
    }

    @Override
    public Undef<D> eval(Finite.Test stmt) {
        VarSet vars = VarExtractor.get(stmt);
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        FiniteDomain newChildState = (FiniteDomain)this.childState;
        VarSet flags = builder.getFlagsFor(vars);
        if (!this.someMayBeZero(flags) && !builder.hasUndefined(vars)) {
            newChildState = newChildState.eval(stmt);
            builder.reduceWithQuery(newChildState, flags);
            newChildState = builder.applyChildOps(newChildState);
        } else {
            builder.promoteToChild(vars);
            newChildState = builder.applyChildOps(newChildState);
            int size = 1;
            Linear sumOfFlags = Undef.buildSumOfVars(flags);
            Linear numberOfFlags = Linear.linear(BigInt.of(flags.size()));
            FiniteDomain allVarsDefinedChildState = newChildState;
            try {
                allVarsDefinedChildState = allVarsDefinedChildState.eval(stmt);
                Finite.Test test = finite.equalTo(size, sumOfFlags, numberOfFlags);
                allVarsDefinedChildState = allVarsDefinedChildState.eval(test);
            }
            catch (Unreachable _) {
                allVarsDefinedChildState = null;
            }
            FiniteDomain someVarsDefinedChildState = newChildState;
            try {
                Finite.Test test = finite.unsignedLessThan(size, sumOfFlags, numberOfFlags);
                someVarsDefinedChildState = someVarsDefinedChildState.eval(test);
            }
            catch (Unreachable _) {
                someVarsDefinedChildState = null;
            }
            newChildState = Undef.joinNullables(allVarsDefinedChildState, someVarsDefinedChildState);
            if (newChildState == null) {
                throw new Unreachable();
            }
            builder.reduceWithQuery(newChildState, flags);
            newChildState = builder.applyChildOps(newChildState);
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public P3<UndefState, D, D> makeCompatible(Undef<D> other, boolean isWideningPoint) {
        UndefStateBuilder thisBuilder = new UndefStateBuilder((UndefState)this.state);
        UndefStateBuilder otherBuilder = new UndefStateBuilder((UndefState)other.state);
        thisBuilder.makeCompatible((FiniteDomain)this.childState, otherBuilder, (FiniteDomain)other.childState);
        FiniteDomain newChildStateOfFst = thisBuilder.applyChildOps((FiniteDomain)this.childState);
        FiniteDomain newChildStateOfSnd = otherBuilder.applyChildOps((FiniteDomain)other.childState);
        UndefState newState = thisBuilder.build();
        return P3.tuple3(newState, newChildStateOfFst, newChildStateOfSnd);
    }

    @Override
    public Undef<D> introduce(NumVar numericVariable, Type type, Option<BigInt> value) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        FiniteDomain newChildState = (FiniteDomain)this.childState;
        if (value.isNone() && type != Type.Address) {
            builder.addUndefined(numericVariable);
        } else {
            newChildState = newChildState.introduce(numericVariable, type, value);
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> project(NumVar variable) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        builder.project(variable);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> substitute(NumVar x, NumVar y) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        builder.substitute(x, y);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> foldNG(ListVarPair vars) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        ListVarPair childVars = builder.foldNG(vars);
        builder.getChildOps().addFoldNG(childVars);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> foldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair vars) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        ListVarPair childVars = builder.foldNG(vars);
        builder.getChildOps().addFoldNG(p, e, childVars);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        return this.build((UndefState)this.state, ((FiniteDomain)this.childState).bendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc));
    }

    @Override
    public Undef<D> bendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        return this.build((UndefState)this.state, ((FiniteDomain)this.childState).bendBackGhostEdgesNG(s, c, svs, cvs, pts, ptc));
    }

    @Override
    public Undef<D> copyAndPaste(VarSet vars, Undef<D> from) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        builder.copyAndPaste(vars, (UndefState)from.state, (FiniteDomain)from.childState);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Range queryRange(Linear linear) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        VarSet vars = linear.getVars();
        if (builder.hasUndefined(vars)) {
            return Range.from(Interval.TOP);
        }
        VarSet flags = builder.getFlagsFor(vars);
        if (this.someMayBeZero(flags)) {
            return Range.from(Interval.TOP);
        }
        return ((FiniteDomain)this.childState).queryRange(linear);
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        if (builder.isUndefined(variable)) {
            return SetOfEquations.empty();
        }
        return ((FiniteDomain)this.childState).queryEqualities(variable);
    }

    private boolean allFlagsTrue(VarSet flags) {
        int size = 1;
        Linear sumOfFlags = Undef.buildSumOfVars(flags);
        Linear numberOfFlags = Linear.linear(BigInt.of(flags.size()));
        try {
            Finite.Test test = finite.equalTo(size, sumOfFlags, numberOfFlags);
            ((FiniteDomain)this.childState).eval(test);
        }
        catch (Unreachable _) {
            return false;
        }
        return true;
    }

    @Override
    public VarSet localSubset(VarSet toTest) {
        return ((UndefState)this.state).getFlagVars(toTest);
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        if (((UndefState)this.state).undefined.contains(var)) {
            builder.append("T");
        } else {
            this.shudf(builder, var);
            ((FiniteDomain)this.childState).varToCompactString(builder, var);
        }
    }

    private void shudf(StringBuilder builder, NumVar var) {
        Option<NumVar.FlagVar> r = ((UndefState)this.state).reverse.get(var);
        if (r.isSome()) {
            ((FiniteDomain)this.childState).varToCompactString(builder, r.get());
            builder.append("\u2192");
        }
    }

    @Override
    public Undef<D> copyVariable(NumVar to, NumVar from) {
        UndefStateBuilder builder1 = new UndefStateBuilder((UndefState)this.state);
        FiniteDomain newChildState = (FiniteDomain)this.childState;
        if (builder1.isUndefined(from)) {
            builder1.addUndefined(to);
        } else {
            Option<NumVar.FlagVar> rhsFlags = builder1.getFlagFor(from);
            if (rhsFlags.isNone()) {
                newChildState = newChildState.copyVariable(to, from);
            } else if (rhsFlags.isSome()) {
                builder1.addToPartition(rhsFlags.get(), to);
                newChildState = newChildState.copyVariable(to, from);
            }
        }
        return this.build(builder1.build(), (D)newChildState);
    }

    @Override
    public P2<AVLSet<NumVar.AddrVar>, Undef<D>> deref(Finite.Rlin ptr) throws Unreachable {
        this.assertDefined(ptr);
        P2 p2 = ((FiniteDomain)this.childState).deref(ptr);
        return new P2<AVLSet<NumVar.AddrVar>, Undef<D>>(p2._1(), this.build((UndefState)this.state, (D)((FiniteDomain)p2._2())));
    }

    private void assertDefined(Finite.Rlin ptr) {
        VarSet vars = ptr.getVars();
        for (NumVar v : vars) {
            this.assertDefined(v);
        }
    }

    private void assertDefined(NumVar var) {
        if (this.mayBeUndefined(var)) {
            this.getContext().addWarning(new UninitializedValue(var));
            throw new Unreachable();
        }
    }

    private boolean mayBeUndefined(NumVar var) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        if (builder.isUndefined(var)) {
            return true;
        }
        VarSet flags = builder.getFlagsFor(var);
        return this.someMayBeZero(flags);
    }

    private boolean someMayBeZero(VarSet flags) {
        for (NumVar flag : flags) {
            if (((FiniteDomain)this.childState).queryRange(flag).isOne()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Undef<D> assumeEdgeNG(Finite.Rlin pointerVar, NumVar.AddrVar targetAddr) {
        this.assertDefined(pointerVar);
        return this.build((UndefState)this.state, ((FiniteDomain)this.childState).assumeEdgeNG(pointerVar, targetAddr));
    }

    @Override
    public Undef<D> expandNG(ListVarPair nvps) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        builder.expandNG(nvps);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> expandNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        builder.expandNG(p, e, nvps);
        FiniteDomain newChildState = builder.applyChildOps((FiniteDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Undef<D> concretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
        return this.build((UndefState)this.state, ((FiniteDomain)this.childState).concretizeAndDisconnectNG(s, cs.difference(((UndefState)this.state).undefined)));
    }

    @Override
    public Undef<D> assumeVarsAreEqual(int size, NumVar fst, NumVar snd) {
        VarSet vars = VarSet.of(fst, snd);
        UndefStateBuilder builder = new UndefStateBuilder((UndefState)this.state);
        FiniteDomain newChildState = (FiniteDomain)this.childState;
        VarSet flags = builder.getFlagsFor(vars);
        if (!this.someMayBeZero(flags) && !builder.hasUndefined(vars)) {
            newChildState = newChildState.assumeVarsAreEqual(size, fst, snd);
            builder.reduceFromNewEqualities(newChildState.getSynthChannel().getEquations());
            newChildState = builder.applyChildOps(newChildState);
        } else {
            builder.promoteToChild(vars);
            newChildState = builder.applyChildOps(newChildState);
            int size1 = 1;
            Linear sumOfFlags = Undef.buildSumOfVars(flags);
            Linear numberOfFlags = Linear.linear(BigInt.of(flags.size()));
            FiniteDomain allVarsDefinedChildState = newChildState;
            try {
                allVarsDefinedChildState = allVarsDefinedChildState.assumeVarsAreEqual(size1, fst, snd);
                Finite.Test test = finite.equalTo(size1, sumOfFlags, numberOfFlags);
                allVarsDefinedChildState = allVarsDefinedChildState.eval(test);
            }
            catch (Unreachable _) {
                allVarsDefinedChildState = null;
            }
            FiniteDomain someVarsDefinedChildState = newChildState;
            try {
                Finite.Test test = finite.unsignedLessThan(size1, sumOfFlags, numberOfFlags);
                someVarsDefinedChildState = someVarsDefinedChildState.eval(test);
            }
            catch (Unreachable _) {
                someVarsDefinedChildState = null;
            }
            newChildState = Undef.joinNullables(allVarsDefinedChildState, someVarsDefinedChildState);
            if (newChildState == null) {
                throw new Unreachable();
            }
            builder.reduceFromNewEqualities(newChildState.getSynthChannel().getEquations());
            newChildState = builder.applyChildOps(newChildState);
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Collection<NumVar.AddrVar> findPossiblePointerTargets(NumVar id) throws Unreachable {
        if (((UndefState)this.state).undefined.contains(id)) {
            return new LinkedList<NumVar.AddrVar>();
        }
        return ((FiniteDomain)this.childState).findPossiblePointerTargets(id);
    }
}

