/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.syntacticstripes;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.syntacticstripes.StripeInliningVisitor;
import bindead.domains.syntacticstripes.StripeProperties;
import bindead.domains.syntacticstripes.StripeState;
import bindead.domains.syntacticstripes.StripeStateBuilder;
import bindead.exceptions.DomainStateException;
import javalx.data.products.P2;
import javalx.numeric.Range;

public class Stripes<D extends ZenoDomain<D>>
extends ZenoFunctor<StripeState, D, Stripes<D>> {
    public static final String NAME = "STRIPES";
    static boolean DEBUGASSIGNMENTS = StripeProperties.INSTANCE.debugAssignments.isTrue();
    static boolean DEBUGTESTS = StripeProperties.INSTANCE.debugTests.isTrue();
    static boolean DEBUGBINARIES = StripeProperties.INSTANCE.debugBinaryOperations.isTrue();
    static boolean DEBUGWIDENING = StripeProperties.INSTANCE.debugWidening.isTrue();
    static boolean DEBUGQUERIES = StripeProperties.INSTANCE.debugQueries.isTrue();
    static boolean DEBUGSUBSETOREQUAL = StripeProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    static boolean DEBUGOTHER = StripeProperties.INSTANCE.debugOther.isTrue();
    private final SynthChannel channel;

    public Stripes(D child) {
        super(NAME, StripeState.EMPTY, child);
        this.channel = null;
    }

    protected Stripes(StripeState state, D childState) {
        super(NAME, state, childState);
        this.channel = null;
    }

    protected Stripes(StripeState state, D childState, SynthChannel channel) {
        super(NAME, state, childState);
        this.channel = channel;
    }

    public Stripes<D> build(StripeState state, D childState, SynthChannel channel) {
        return new Stripes<D>(state, childState, channel);
    }

    @Override
    public Stripes<D> build(StripeState state, D childState) {
        return new Stripes<D>(state, childState);
    }

    @Override
    public Stripes<D> eval(Zeno.Assign stmt) {
        Zeno.Assign assign = StripeInliningVisitor.run(stmt, (StripeState)this.state);
        StripeStateBuilder sys = new StripeStateBuilder((StripeState)this.state, true);
        if (stmt.getRhs() instanceof Zeno.Rlin) {
            Zeno.Rlin lin = (Zeno.Rlin)stmt.getRhs();
            StripeStateBuilder.Transformation t = new StripeStateBuilder.Transformation((QueryChannel)((Object)this.childState), stmt.getLhs(), lin);
            sys.applyAffineTransformation(t);
        } else {
            sys.removeVariable(stmt.getLhs().getId());
        }
        if (DEBUGASSIGNMENTS) {
            System.out.println(this.name + ": ");
            System.out.println("  evaluating: " + stmt + " that is: " + assign);
            System.out.println("  on child: " + sys.getChildOps());
            System.out.println("  stripes: " + ((StripeState)this.state).stripes + " |-> " + sys.stripes);
            System.out.println("  child: " + this.childState);
        }
        ZenoDomain newChildState = sys.applyChildOps((ZenoDomain)this.childState);
        newChildState = newChildState.eval(assign);
        if (DEBUGASSIGNMENTS) {
            System.out.println("  child: " + newChildState);
        }
        return this.build(sys.build(), (D)newChildState);
    }

    @Override
    public Stripes<D> eval(Zeno.Test stmt) {
        Linear expr;
        Linear lin;
        ZenoDomain newChildState = (ZenoDomain)this.childState;
        newChildState = newChildState.eval(stmt);
        if (DEBUGTESTS) {
            System.out.println(this.name + ": ");
            System.out.println("  evaluating test: " + stmt);
            System.out.println("  this: " + this.state);
            System.out.println("  before: " + this.childState);
            System.out.println("  after: " + newChildState);
        }
        if ((lin = ((StripeState)this.state).inlineSyntactically(expr = stmt.getExpr())) != expr) {
            Zeno.Test t = stmt.withExpr(lin);
            if (DEBUGTESTS) {
                System.out.println("  evaluating test: " + t);
                System.out.println("  child: " + this.state);
            }
            newChildState = newChildState.eval(t);
        }
        P2<ZenoDomain, SynthChannel> res = ((StripeState)this.state).applyStripes(stmt, newChildState);
        newChildState = res._1();
        return this.build((StripeState)this.state, newChildState, res._2());
    }

    @Override
    public Stripes<D> expand(FoldMap vars) {
        throw new DomainStateException.UnimplementedMethodException();
    }

    @Override
    public Stripes<D> fold(FoldMap vars) {
        throw new DomainStateException.UnimplementedMethodException();
    }

    @Override
    public Stripes<D> join(Stripes<D> other) {
        StripeStateBuilder fst = new StripeStateBuilder((StripeState)this.state, true);
        StripeStateBuilder snd = new StripeStateBuilder((StripeState)other.state, true);
        StripeStateBuilder.makeCompatible(fst, snd);
        if (DEBUGBINARIES) {
            System.out.println(this.name + ": ");
            System.out.println("  fst: " + ((StripeState)this.state).stripes);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + ((StripeState)other.state).stripes);
            System.out.println("    on child: " + snd.getChildOps());
            System.out.println("  join: " + fst.stripes);
            System.out.println("  fst child: " + this.childState);
            System.out.println("  snd child: " + other.childState);
        }
        ZenoDomain newChildStateOfFst = fst.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain newChildStateOfSnd = snd.applyChildOps((ZenoDomain)other.childState);
        ZenoDomain newChildState = newChildStateOfFst.join(newChildStateOfSnd);
        if (DEBUGBINARIES) {
            System.out.println("  child: " + newChildState);
        }
        return this.build(fst.build(), (D)newChildState);
    }

    @Override
    public Stripes<D> widen(Stripes<D> other) {
        StripeStateBuilder fst = new StripeStateBuilder((StripeState)this.state);
        StripeStateBuilder snd = new StripeStateBuilder((StripeState)other.state);
        StripeStateBuilder.makeCompatibleForWidening(fst, snd);
        fst.findNarrowingConstraints((QueryChannel)((Object)this.childState), (QueryChannel)((Object)other.childState));
        if (DEBUGWIDENING) {
            System.out.println(this.name + ": ");
            System.out.println("  fst: " + ((StripeState)this.state).stripes);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + ((StripeState)other.state).stripes);
            System.out.println("    on child: " + snd.getChildOps());
            System.out.println("  widen: " + fst.stripes);
            System.out.println("  narrowing: " + fst.narrowingconstraints);
            System.out.println("  fst child: " + this.childState);
            System.out.println("  snd child: " + other.childState);
        }
        ZenoDomain newChildStateOfFst = fst.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain newChildStateOfSnd = snd.applyChildOps((ZenoDomain)other.childState);
        ZenoDomain newChildState = newChildStateOfFst.widen(newChildStateOfSnd);
        if (DEBUGWIDENING) {
            System.out.println("  child: " + newChildState);
        }
        return this.build(fst.build(), (D)newChildState);
    }

    @Override
    public boolean subsetOrEqual(Stripes<D> other) {
        StripeStateBuilder fst = new StripeStateBuilder((StripeState)this.state);
        StripeStateBuilder snd = new StripeStateBuilder((StripeState)other.state);
        StripeStateBuilder.makeCompatibleForWidening(fst, snd);
        if (DEBUGSUBSETOREQUAL) {
            System.out.println(this.name + ":");
            System.out.println("  subset-or-equal:");
            System.out.println("  fst: " + ((StripeState)this.state).stripes + " |-> " + fst.stripes);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + ((StripeState)other.state).stripes + " |-> " + snd.stripes);
            System.out.println("    on child: " + snd.getChildOps());
        }
        ZenoDomain newChildStateOfFst = fst.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain newChildStateOfSnd = snd.applyChildOps((ZenoDomain)other.childState);
        return newChildStateOfFst.subsetOrEqual(newChildStateOfSnd);
    }

    @Override
    public Stripes<D> project(VarSet vars) {
        Stripes<D> d = this;
        for (NumVar v : vars) {
            d = d.project(v);
        }
        return d;
    }

    public Stripes<D> project(NumVar variable) {
        StripeStateBuilder sys = new StripeStateBuilder((StripeState)this.state, true);
        if (((StripeState)this.state).notInSupport(variable)) {
            Object newChildState = ((ZenoDomain)this.childState).project(VarSet.of(variable));
            return this.build((StripeState)this.state, newChildState);
        }
        sys.applyProjection(variable, (QueryChannel)((Object)this.childState));
        if (DEBUGOTHER) {
            System.out.println(this.name + ": ");
            System.out.println("  projecting: " + variable);
            System.out.println("  on child: " + sys.getChildOps());
            System.out.println("  stripes: " + ((StripeState)this.state).stripes + " |-> " + sys.stripes);
            System.out.println("  child: " + this.childState);
        }
        ZenoDomain newChildState = sys.applyChildOps((ZenoDomain)this.childState);
        if (DEBUGOTHER) {
            System.out.println("  child: " + newChildState);
            System.out.flush();
        }
        newChildState = newChildState.project(VarSet.of(variable));
        StripeState newState = sys.build();
        assert (newState.notInSupport(variable));
        return this.build(newState, (D)newChildState);
    }

    @Override
    public Stripes<D> substitute(NumVar x, NumVar y) {
        assert (((StripeState)this.state).notInSupport(y));
        if (((StripeState)this.state).notInSupport(x)) {
            Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
            return this.build((StripeState)this.state, newChildState);
        }
        StripeStateBuilder sys = new StripeStateBuilder((StripeState)this.state, true);
        sys.applyDirectSubstitution(x, y);
        if (DEBUGOTHER) {
            System.out.println(this.name + ": ");
            System.out.println("  substitute: [" + x + "\\" + y + "]");
            System.out.println("  on child: " + sys.getChildOps());
            System.out.println("  child: " + this.childState);
        }
        ZenoDomain newChildState = sys.applyChildOps((ZenoDomain)this.childState);
        newChildState = newChildState.substitute(x, y);
        if (DEBUGOTHER) {
            System.out.println("  stripes: " + ((StripeState)this.state).stripes + " |-> " + sys.stripes);
            System.out.println("  constraints: " + ((StripeState)this.state).narrowingconstraints + " |-> " + sys.narrowingconstraints);
            System.out.println("  child: " + newChildState);
            System.out.flush();
        }
        StripeState newState = sys.build();
        assert (newState.notInSupport(x));
        return this.build(newState, (D)newChildState);
    }

    @Override
    public Range queryRange(Linear lin) {
        Linear inlined = ((StripeState)this.state).inlineSyntactically(lin);
        Range range = ((ZenoDomain)this.childState).queryRange(inlined);
        if (DEBUGQUERIES) {
            System.out.println(this.name + ": ");
            System.out.println("  query: " + lin + " that is: " + inlined);
            System.out.println("  is in range: " + range);
            System.out.println("  stripes: " + ((StripeState)this.state).stripes);
            System.out.println("  child: " + this.childState);
            System.out.flush();
        }
        return range;
    }

    @Override
    public VarSet localSubset(VarSet toTest) {
        return toTest.intersection(((StripeState)this.state).getLocalVariables());
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel channel = this.channel != null ? this.channel : ((ZenoDomain)this.childState).getSynthChannel();
        return channel.removeVariables(this.localSubset(channel.getVariables()));
    }

    @Override
    public Stripes<D> copyAndPaste(VarSet vars, Stripes<D> from) {
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).copyAndPaste(vars, (Summarization)((Object)from.childState));
        return this.build((StripeState)this.state, (D)newChildState);
    }
}

